/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.instructions.BranchInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.code.instructions.LookupSwitchInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.ReferenceInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.TableSwitchInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.WideBranchInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.WideInstruction;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;

public abstract class AInstruction {
    public abstract byte[] getBytecode(int var1, LineNumberTable var2);

    public abstract byte getOpcode();

    public abstract int getBytecodeLength(int var1);

    public abstract int[] getBranchTargets();

    public abstract void setBranchTargets(int[] var1);

    public static AInstruction makeInstruction(byte[] bytecode, int pc, int paddingPC, LineNumberTable lnt) {
        byte o = bytecode[pc];
        switch (o) {
            case -86: {
                return new TableSwitchInstruction(bytecode, pc, paddingPC, lnt);
            }
            case -85: {
                return new LookupSwitchInstruction(bytecode, pc, paddingPC, lnt);
            }
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -58: 
            case -57: {
                return new BranchInstruction(bytecode, pc, paddingPC, lnt);
            }
            case -56: 
            case -55: {
                return new WideBranchInstruction(bytecode, pc, paddingPC, lnt);
            }
            case -60: {
                return new WideInstruction(bytecode, pc, paddingPC, lnt);
            }
            case -78: 
            case -77: 
            case -76: 
            case -75: 
            case -74: 
            case -73: 
            case -72: 
            case -69: 
            case -67: 
            case -64: 
            case -63: 
            case 18: 
            case 19: 
            case 20: {
                return new ReferenceInstruction(bytecode, pc, paddingPC, lnt);
            }
        }
        return new GenericInstruction(bytecode, pc, paddingPC, lnt);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toStringVerbose(ConstantPool cp) {
        return this.toString();
    }

    public static AInstruction getCorrespondingStore(AInstruction loadInstruction) {
        byte opcode = loadInstruction.getOpcode();
        if (opcode == -60) {
            WideInstruction wi = (WideInstruction)loadInstruction;
            byte[] code = wi.getBytecode();
            byte opcode2 = code[1];
            if (opcode2 >= 21 && opcode2 <= 25) {
                return new WideInstruction(new byte[]{(byte)(opcode2 + 33), code[2], code[3]});
            }
        } else {
            if (opcode >= 21 && opcode <= 25) {
                GenericInstruction gi = (GenericInstruction)loadInstruction;
                byte[] code = gi.getBytecode();
                return new GenericInstruction((byte)(opcode + 33), code[1]);
            }
            if (opcode >= 26 && opcode <= 45) {
                return new GenericInstruction((byte)(opcode + 33));
            }
            if (opcode >= 46 && opcode <= 53) {
                GenericInstruction gi = (GenericInstruction)loadInstruction;
                byte[] code = gi.getBytecode();
                return new GenericInstruction((byte)(opcode + 33));
            }
        }
        throw new IllegalArgumentException("Invalid load instruction");
    }

    public static AInstruction getCorrespondingLoad(AInstruction storeInstruction) {
        byte opcode = storeInstruction.getOpcode();
        if (opcode == -60) {
            WideInstruction wi = (WideInstruction)storeInstruction;
            byte[] code = wi.getBytecode();
            byte opcode2 = code[1];
            if (opcode2 >= 54 && opcode2 <= 58) {
                return new WideInstruction(new byte[]{(byte)(opcode2 - 33), code[2], code[3]});
            }
        } else {
            if (opcode >= 54 && opcode <= 58) {
                GenericInstruction gi = (GenericInstruction)storeInstruction;
                byte[] code = gi.getBytecode();
                return new GenericInstruction((byte)(opcode - 33), code[1]);
            }
            if (opcode >= 59 && opcode <= 78) {
                return new GenericInstruction((byte)(opcode - 33));
            }
            if (opcode >= 79 && opcode <= 86) {
                GenericInstruction gi = (GenericInstruction)storeInstruction;
                byte[] code = gi.getBytecode();
                return new GenericInstruction((byte)(opcode - 33));
            }
        }
        throw new IllegalArgumentException("Invalid store instruction");
    }
}

