/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;

public class WideInstruction
extends GenericInstruction {
    public WideInstruction(byte[] code) {
        super(0);
        switch (code[0]) {
            case -124: 
            case -87: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal wide instruction");
            }
        }
        this._code = new byte[code.length + 1];
        this._code[0] = -60;
        System.arraycopy(code, 0, this._code, 1, code.length);
    }

    public byte getOpcode() {
        return -60;
    }

    public int getBytecodeLength(int pc) {
        switch (this._code[1]) {
            case -87: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return 4;
            }
            case -124: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Illegal wide instruction");
    }

    public WideInstruction(byte[] bytecode, int pc, int paddingPC, LineNumberTable lnt) {
        super(bytecode, pc, paddingPC, lnt);
    }

    public int hashCode() {
        return this._code[2];
    }

    public void setBranchTargets(int[] branchTargets) {
        if (branchTargets.length != 0) {
            throw new IllegalArgumentException("Wide instruction cannot have a target");
        }
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(Opcode.getOpcodeName((byte)-60));
        x.append(" ");
        x.append(Opcode.getOpcodeName(this._code[1]));
        x.append(" ");
        for (int i = 2; i < this._code.length; ++i) {
            x.append(String.format("%02x", new Byte(this._code[i])) + " ");
        }
        return x.toString();
    }
}

