/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.IPoolInfoVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublePoolInfo
extends APoolInfo {
    private double _doubleValue;

    public DoublePoolInfo(double d, ConstantPool cp) {
        super(6, cp);
        this._doubleValue = d;
    }

    public DoublePoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(6, cp);
        this._doubleValue = dis.readDouble();
    }

    public double getDoubleValue() {
        return this._doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        this._doubleValue = doubleValue;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this._type);
        dos.writeDouble(this._doubleValue);
    }

    @Override
    public void resolve() {
    }

    @Override
    public void reindex() {
    }

    @Override
    public String toStringVerbose() {
        StringBuilder s = new StringBuilder();
        s.append("CONSTANT_Double: Value = ");
        s.append(this.toString());
        return s.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this._doubleValue);
    }

    @Override
    public int hashCode() {
        return new Double(this._doubleValue).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DoublePoolInfo && ((DoublePoolInfo)obj)._doubleValue == this._doubleValue;
    }

    @Override
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.doubleCase(this, data);
    }
}

