/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.IPoolInfoVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongPoolInfo
extends APoolInfo {
    private long _longValue;

    public LongPoolInfo(long l, ConstantPool cp) {
        super(5, cp);
        this._longValue = l;
    }

    public LongPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(5, cp);
        this._longValue = dis.readLong();
    }

    public long getLongValue() {
        return this._longValue;
    }

    public void setLongValue(long longValue) {
        this._longValue = longValue;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this._type);
        dos.writeLong(this._longValue);
    }

    @Override
    public void resolve() {
    }

    @Override
    public void reindex() {
    }

    @Override
    public String toStringVerbose() {
        StringBuilder s = new StringBuilder();
        s.append("CONSTANT_Long: Value = ");
        s.append(this.toString());
        return s.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this._longValue);
    }

    @Override
    public int hashCode() {
        return new Long(this._longValue).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof LongPoolInfo && ((LongPoolInfo)obj)._longValue == this._longValue;
    }

    @Override
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.longCase(this, data);
    }
}

