/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors;

import edu.rice.cs.cunit.SyncPointBuffer;
import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.ReferenceInstruction;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ASCIIPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.MethodPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckClassVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckMethodVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;
import edu.rice.cs.cunit.util.Types;

public class AssignThreadIDStrategy
implements IInstrumentationStrategy {
    public void instrument(ClassFile cf) {
        if (cf.getThisClassName().equals("java.lang.Thread")) {
            int threadID = cf.addField(cf.getThisClass().getName().toString(), "$$$threadID$$$", "J", true, (short)129);
            int oldThread = cf.addField(cf.getThisClass().getName().toString(), "$$$oldThread$$$", "Z", true, (short)129);
            int nextThreadID = cf.addField("edu/rice/cs/cunit/SyncPointBuffer", "_nextThreadID", "J", false, (short)0);
            for (MethodInfo mi : cf.getMethods()) {
                if (!mi.getName().toString().equals("<init>")) continue;
                this.processCtor(cf, mi, threadID, nextThreadID, oldThread);
            }
        }
    }

    protected void processCtor(ClassFile cf, MethodInfo mi, int threadID, int nextThreadID, int oldThread) {
        CodeAttributeInfo codeAttr = mi.getCodeAttributeInfo();
        InstructionList il = new InstructionList(codeAttr.getCode());
        boolean ctorCalled = false;
        do {
            ReferenceInstruction ri;
            short method;
            MethodPoolInfo mpi;
            if (il.getOpcode() != -73 || !(mpi = cf.getConstantPoolItem(method = Types.shortFromBytes((ri = (ReferenceInstruction)il.getInstr()).getBytecode(), 1)).execute(CheckMethodVisitor.singleton(), null)).getClassInfo().getName().toString().equals(cf.getThisClass().getName().toString()) || !mpi.getNameAndType().getName().toString().equals("<init>")) continue;
            ctorCalled = true;
            break;
        } while (il.advanceIndex());
        if (ctorCalled) {
            return;
        }
        il.setIndex(0);
        ConstantPool cp = cf.getConstantPool();
        int threadIDIndex = cf.addField("java/lang/Thread", "$$$threadID$$$", "J", true, (short)129);
        int nextThreadIDIndex = cf.addField("edu/rice/cs/cunit/SyncPointBuffer", "_nextThreadID", "J", false, (short)0);
        ReferenceInstruction addCallInstr = new ReferenceInstruction(-72, 0);
        ReferenceInstruction loadMonitorEnterCodeIndexInstr = new ReferenceInstruction(20, 0);
        ReferenceInstruction loadMonitorTryEnterCodeIndexInstr = new ReferenceInstruction(20, 0);
        ReferenceInstruction loadMonitorExitCodeIndexInstr = new ReferenceInstruction(20, 0);
        ReferenceInstruction getThreadIDInstr = new ReferenceInstruction(-76, 0);
        ReferenceInstruction currentThreadCallInstr = new ReferenceInstruction(-72, 0);
        int addCallIndex = cf.addMethodToConstantPool("edu/rice/cs/cunit/SyncPointBuffer", "compactAdd", "(JJ)V");
        addCallInstr.setReference(addCallIndex);
        int monitorEnterCodeIndex = cf.addLongToConstantPool(SyncPointBuffer.SP.THREADID_MONITORENTER.intValue());
        loadMonitorEnterCodeIndexInstr.setReference(monitorEnterCodeIndex);
        int monitorTryEnterCodeIndex = cf.addLongToConstantPool(SyncPointBuffer.SP.THREADID_TRYMONITORENTER.intValue());
        loadMonitorTryEnterCodeIndexInstr.setReference(monitorTryEnterCodeIndex);
        getThreadIDInstr.setReference(threadIDIndex);
        int currentThreadCallIndex = cf.addMethodToConstantPool("java/lang/Thread", "currentThread", "()Ljava/lang/Thread;");
        currentThreadCallInstr.setReference(currentThreadCallIndex);
        AUTFPoolInfo sprClassName = new ASCIIPoolInfo("edu/rice/cs/cunit/SyncPointBuffer", cp);
        int[] l = cf.addConstantPoolItems(new APoolInfo[]{sprClassName});
        sprClassName = cf.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        ClassPoolInfo sprClass = new ClassPoolInfo(sprClassName, cp);
        l = cf.addConstantPoolItems(new APoolInfo[]{sprClass});
        sprClass = cf.getConstantPoolItem(l[0]).execute(CheckClassVisitor.singleton(), null);
        int sprClassIndex = l[0];
        int monitorExitCodeIndex = cf.addLongToConstantPool(SyncPointBuffer.SP.THREADID_MONITOREXIT.intValue());
        loadMonitorExitCodeIndexInstr.setReference(monitorExitCodeIndex);
        il.insertBeforeInstr(loadMonitorTryEnterCodeIndexInstr, mi.getCodeAttributeInfo());
        boolean result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(currentThreadCallInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(getThreadIDInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(addCallInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        byte[] instr = new byte[]{19, 0, 0};
        Types.bytesFromShort((short)(sprClassIndex & 0xFFFF), instr, 1);
        il.insertBeforeInstr(new GenericInstruction(instr), codeAttr);
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(new GenericInstruction(-62), codeAttr);
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(loadMonitorEnterCodeIndexInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(currentThreadCallInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(getThreadIDInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(addCallInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(new GenericInstruction(42), codeAttr);
        result = il.advanceIndex();
        assert (result);
        instr[0] = -78;
        Types.bytesFromShort((short)(nextThreadIDIndex & 0xFFFF), instr, 1);
        il.insertBeforeInstr(new GenericInstruction(instr), codeAttr);
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(new GenericInstruction(92), codeAttr);
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(new GenericInstruction(10), codeAttr);
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(new GenericInstruction(97), codeAttr);
        result = il.advanceIndex();
        assert (result);
        instr[0] = -77;
        il.insertBeforeInstr(new GenericInstruction(instr), codeAttr);
        result = il.advanceIndex();
        assert (result);
        instr[0] = -75;
        Types.bytesFromShort((short)(threadIDIndex & 0xFFFF), instr, 1);
        il.insertBeforeInstr(new GenericInstruction(instr), codeAttr);
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(loadMonitorExitCodeIndexInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(currentThreadCallInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(getThreadIDInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(addCallInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
        instr[0] = 19;
        Types.bytesFromShort((short)(sprClassIndex & 0xFFFF), instr, 1);
        il.insertBeforeInstr(new GenericInstruction(instr), codeAttr);
        result = il.advanceIndex();
        assert (result);
        il.insertBeforeInstr(new GenericInstruction(-61), codeAttr);
        result = il.advanceIndex();
        assert (result);
        codeAttr.setCode(il.getCode());
        CodeAttributeInfo.CodeProperties codeProps = mi.getCodeAttributeInfo().getProperties();
        codeProps.maxStack = (short)Math.max(7, codeProps.maxStack);
        mi.getCodeAttributeInfo().setProperties(codeProps.maxStack, codeProps.maxLocals);
    }

    public void done() {
    }
}

