/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors;

import edu.rice.cs.cunit.instrumentors.RetryIOException;
import java.io.File;
import java.io.IOException;

public class CouldNotRenameException
extends RetryIOException {
    private File _oldFile = null;
    private File _newFile = null;

    public CouldNotRenameException(File oldFile, File newFile) {
        super("Could not rename file " + oldFile.getPath() + " to " + newFile.getPath());
        this._oldFile = oldFile;
        this._newFile = newFile;
    }

    public void retry() throws IOException {
        if (this._oldFile.exists() && !this._newFile.exists()) {
            if (this._oldFile.exists() && !this._oldFile.renameTo(this._newFile)) {
                throw new IOException(this.getMessage());
            }
        } else {
            throw new IOException(this.getMessage() + "; cannot fix, situation not applicable");
        }
    }
}

