/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.record;

import edu.rice.cs.cunit.SyncPointBuffer;
import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.instructions.ReferenceInstruction;
import edu.rice.cs.cunit.classFile.constantPool.MethodPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckMethodVisitor;
import edu.rice.cs.cunit.instrumentors.record.CompactRecordBufferCodeStrategy;
import edu.rice.cs.cunit.util.IPredicate;

public class CompactRecordThreadStartStrategy
extends CompactRecordBufferCodeStrategy {
    public CompactRecordThreadStartStrategy() {
        super(new IPredicate<ClassFile>(){

            @Override
            public Boolean apply(ClassFile param) {
                return param.getThisClassName().equals("java.lang.Thread");
            }
        }, new IPredicate.Binary<ClassFile, MethodInfo>(){

            @Override
            public Boolean apply(ClassFile cf, MethodInfo param) {
                return param.getName().toString().equals("start");
            }
        }, new IPredicate.Ternary<ClassFile, MethodInfo, InstructionList>(){

            @Override
            public Boolean apply(ClassFile cf, MethodInfo mi, InstructionList il) {
                if (il.getOpcode() != -73) {
                    return false;
                }
                int methodIndex = ((ReferenceInstruction)il.getInstr()).getReference();
                MethodPoolInfo mpi = cf.getConstantPoolItem(methodIndex).execute(CheckMethodVisitor.singleton(), null);
                return mpi.getClassInfo().getName().toString().equals("java/lang/Thread") && mpi.getNameAndType().getName().toString().equals("start0") && mpi.getNameAndType().getDescriptor().toString().equals("()V");
            }
        }, SyncPointBuffer.SP.THREADSTART.intValue());
    }
}

