/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import edu.rice.cs.cunit.util.ProvidesInputStreamPosition;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PositionInputStream
extends FilterInputStream
implements ProvidesInputStreamPosition {
    private long pos = 0L;
    private long mark = 0L;

    public PositionInputStream(InputStream in) {
        super(in);
    }

    public synchronized long getPosition() {
        return this.pos;
    }

    public synchronized int read() throws IOException {
        int b = super.read();
        if (b >= 0) {
            ++this.pos;
        }
        return b;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }

    public synchronized long skip(long skip) throws IOException {
        long n = super.skip(skip);
        if (n > 0L) {
            this.pos += n;
        }
        return n;
    }

    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.pos;
    }

    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("Mark not supported.");
        }
        super.reset();
        this.pos = this.mark;
    }
}

