/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TextAreaMessageDialog
extends JDialog {
    public static void showDialog(Component comp, String title, String message) {
        Frame frame = JOptionPane.getFrameForComponent(comp);
        TextAreaMessageDialog dialog = new TextAreaMessageDialog(frame, comp, title, message);
        dialog.setVisible(true);
    }

    private TextAreaMessageDialog(Frame frame, Component comp, String title, String message) {
        super(frame, title, true);
        this.setDefaultCloseOperation(2);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextAreaMessageDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JTextArea textArea = new JTextArea(message);
        textArea.setFont(UIManager.getFont("TextField.font"));
        textArea.setEditable(false);
        textArea.setLineWrap(false);
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        textArea.setBorder(emptyBorder);
        JScrollPane sp = new JScrollPane(textArea);
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(22);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)sp, "Center");
        contentPane.add((Component)okButton, "South");
        Dimension parentDim = comp != null ? comp.getSize() : this.getToolkit().getScreenSize();
        int xs = (int)parentDim.getWidth();
        int ys = (int)parentDim.getHeight();
        this.setSize(Math.max(xs, 350), Math.max(ys, 250));
        this.setLocationRelativeTo(comp);
    }
}

