/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.MainFrame;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

public final class RemoteControlServer {
    public static final String QUERY_PREFIX = "DrJava Remote Control?";
    public static final String RESPONSE_PREFIX = "DrJava Remote Control ";
    public static final String RESPONSE_PREFIX_WITH_USER = "DrJava Remote Control " + System.getProperty("user.name") + "!";

    public RemoteControlServer(MainFrame frame) throws IOException {
        RCServerThread rcsThread = new RCServerThread(frame);
        rcsThread.setDaemon(true);
        rcsThread.start();
    }

    public static void main(String[] args) {
        try {
            new RCServerThread(null).start();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
    }

    public static class RCServerThread
    extends Thread {
        protected MainFrame _frame;
        protected DatagramSocket socket = null;

        public RCServerThread(MainFrame frame) throws IOException {
            this("RCServerThread", frame);
        }

        public RCServerThread(String name, MainFrame frame) throws IOException {
            super(name);
            this._frame = frame;
            this.socket = new DatagramSocket(DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_PORT));
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        byte[] buf = new byte[256];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        this.socket.receive(packet);
                        String request = new String(packet.getData(), 0, packet.getLength());
                        if (!request.startsWith(RemoteControlServer.QUERY_PREFIX)) continue;
                        String dString = RESPONSE_PREFIX_WITH_USER;
                        if ((request = request.substring(RemoteControlServer.QUERY_PREFIX.length())).length() > 0 && request.charAt(0) == ' ') {
                            File f;
                            request = request.substring(1);
                            int lineNo = -1;
                            int pathSepIndex = request.indexOf(File.pathSeparatorChar);
                            if (pathSepIndex >= 0) {
                                try {
                                    lineNo = Integer.valueOf(request.substring(pathSepIndex + 1));
                                }
                                catch (NumberFormatException nfe) {
                                    lineNo = -1;
                                }
                                request = request.substring(0, pathSepIndex);
                            }
                            if ((f = new File(request)).exists()) {
                                DrJavaRoot.handleRemoteOpenFile(f, lineNo);
                            }
                        } else {
                            dString = dString + " Cannot open file!";
                        }
                        buf = dString.getBytes();
                        InetAddress address = packet.getAddress();
                        int port = packet.getPort();
                        packet = new DatagramPacket(buf, buf.length, address, port);
                        this.socket.send(packet);
                    }
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        protected void finalize() {
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }
}

