/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.plt.object.ObjectUtil;
import java.util.Arrays;

public interface Query {

    public static class EnclosingClassName
    implements Query {
        private int _pos;
        private boolean _qual;

        public EnclosingClassName(int pos, boolean qual) {
            this._pos = pos;
            this._qual = qual;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            EnclosingClassName o = (EnclosingClassName)other;
            return o._pos == this._pos && o._qual == this._qual;
        }

        public int hashCode() {
            return ObjectUtil.hash(this.getClass().hashCode(), this._pos, this._qual ? 1 : 0);
        }
    }

    public static class AnonymousInnerClassIndex
    extends Pos {
        public AnonymousInnerClassIndex(int pos) {
            super(pos);
        }
    }

    public static class AnonymousInnerClass
    implements Query {
        private final int _pos;
        private final int _openCurlyPos;

        public AnonymousInnerClass(int pos, int openCurlyPos) {
            this._pos = pos;
            this._openCurlyPos = openCurlyPos;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            AnonymousInnerClass o = (AnonymousInnerClass)other;
            return o._pos == this._pos && o._openCurlyPos == this._openCurlyPos;
        }

        public int hashCode() {
            return ObjectUtil.hash(this.getClass().hashCode(), this._pos, this._openCurlyPos);
        }
    }

    public static class PosInBlockComment
    extends Pos {
        public PosInBlockComment(int pos) {
            super(pos);
        }
    }

    public static class PosNotInBlock
    extends Pos {
        public PosNotInBlock(int pos) {
            super(pos);
        }
    }

    public static class EnclosingBrace
    extends Pos {
        public EnclosingBrace(int pos) {
            super(pos);
        }
    }

    public static class LineEnclosingBrace
    extends Pos {
        public LineEnclosingBrace(int pos) {
            super(pos);
        }
    }

    public static class PosInParenPhrase
    extends Pos {
        public PosInParenPhrase(int pos) {
            super(pos);
        }
    }

    public static class FirstNonWSCharPos
    extends CharArrayAndFlag {
        FirstNonWSCharPos(int pos, char[] whitespace, boolean acceptComments) {
            super(pos, whitespace, acceptComments);
        }
    }

    public static class LineFirstCharPos
    extends Pos {
        public LineFirstCharPos(int pos) {
            super(pos);
        }
    }

    public static class LineEndPos
    extends Pos {
        public LineEndPos(int pos) {
            super(pos);
        }
    }

    public static class LineStartPos
    extends Pos {
        public LineStartPos(int pos) {
            super(pos);
        }
    }

    public static class CharOnLine
    implements Query {
        private final int _pos;
        private final char _findChar;

        public CharOnLine(int pos, char findChar) {
            this._pos = pos;
            this._findChar = findChar;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            CharOnLine o = (CharOnLine)other;
            return o._pos == this._pos && o._findChar == this._findChar;
        }

        public int hashCode() {
            return ObjectUtil.hash(this.getClass().hashCode(), this._pos, (int)this._findChar);
        }
    }

    public static class IndentOfCurrStmt
    implements Query {
        private final int _pos;
        private final char[] _delims;
        private final char[] _whitespace;

        public IndentOfCurrStmt(int pos, char[] delims, char[] whitespace) {
            this._pos = pos;
            this._delims = delims;
            this._whitespace = whitespace;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            IndentOfCurrStmt o = (IndentOfCurrStmt)other;
            return o._pos == this._pos && Arrays.equals(o._delims, this._delims) && Arrays.equals(o._whitespace, this._whitespace);
        }

        public int hashCode() {
            return ObjectUtil.hash(this.getClass().hashCode(), this._pos ^ this._delims[0], this._delims[this._delims.length - 1], this._whitespace[0], this._whitespace[this._whitespace.length - 1]);
        }
    }

    public static class PrevCharPos
    implements Query {
        private final int _pos;
        private final char[] _whitespace;

        public PrevCharPos(int pos, char[] whitespace) {
            this._pos = pos;
            this._whitespace = whitespace;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            PrevCharPos o = (PrevCharPos)other;
            return o._pos == this._pos && Arrays.equals(o._whitespace, this._whitespace);
        }

        public int hashCode() {
            return ObjectUtil.hash(this.getClass().hashCode(), this._pos, (int)this._whitespace[0], (int)this._whitespace[this._whitespace.length - 1]);
        }
    }

    public static class PrevDelimiter
    extends CharArrayAndFlag {
        public PrevDelimiter(int pos, char[] delims, boolean skipParenPhrases) {
            super(pos, delims, skipParenPhrases);
        }
    }

    public static abstract class CharArrayAndFlag
    implements Query {
        private final int _pos;
        private final char[] _chars;
        private final boolean _flag;

        public CharArrayAndFlag(int pos, char[] chars, boolean flag) {
            this._pos = pos;
            this._chars = chars;
            this._flag = flag;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            CharArrayAndFlag o = (CharArrayAndFlag)other;
            return o._pos == this._pos && Arrays.equals(o._chars, this._chars) && o._flag == this._flag;
        }

        public int hashCode() {
            return ObjectUtil.hash(this.getClass().hashCode(), this._pos, this._chars[0], this._chars[this._chars.length - 1], this._flag ? 1 : 0);
        }
    }

    public static class NextEnclosingBrace
    extends AbstractEnclosingBrace {
        public NextEnclosingBrace(int pos, char opening, char closing) {
            super(pos, opening, closing);
        }
    }

    public static class PrevEnclosingBrace
    extends AbstractEnclosingBrace {
        public PrevEnclosingBrace(int pos, char opening, char closing) {
            super(pos, opening, closing);
        }
    }

    public static abstract class AbstractEnclosingBrace
    implements Query {
        private final int _pos;
        private final char _opening;
        private final char _closing;

        public AbstractEnclosingBrace(int pos, char opening, char closing) {
            this._pos = pos;
            this._opening = opening;
            this._closing = closing;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            AbstractEnclosingBrace o = (AbstractEnclosingBrace)other;
            return o._pos == this._pos && o._opening == this._opening && o._closing == this._closing;
        }

        public int hashCode() {
            return ObjectUtil.hash(this.getClass().hashCode(), this._pos, (int)this._opening, (int)this._closing);
        }
    }

    public static class IndentInformation
    extends Pos {
        public IndentInformation(int pos) {
            super(pos);
        }
    }

    public static abstract class Pos
    implements Query {
        private final int _pos;

        Pos(int pos) {
            this._pos = pos;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            Pos o = (Pos)other;
            return o._pos == this._pos;
        }

        public int hashCode() {
            return ObjectUtil.hash(this.getClass().hashCode(), this._pos);
        }
    }
}

