/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.AbstractReducedModel;
import edu.rice.cs.drjava.model.definitions.reducedmodel.Brace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelControl;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;
import java.util.Stack;

public class ReducedModelBrace
extends AbstractReducedModel {
    private ReducedModelControl _parent;

    public ReducedModelBrace(ReducedModelControl parent) {
        this._parent = parent;
    }

    public void insertChar(char ch) {
        switch (ch) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                this._insertBrace(String.valueOf(ch));
                break;
            }
            default: {
                this._insertGap(1);
            }
        }
    }

    private void _insertBrace(String text) {
        if (this._cursor.atStart() || this._cursor.atEnd()) {
            this._cursor.insertNewBrace(text);
        } else if (this.current().isGap()) {
            this._cursor.insertBraceToGap(text);
        } else {
            this._cursor.insertNewBrace(text);
        }
    }

    protected void insertGapBetweenMultiCharBrace(int length) {
        throw new RuntimeException("ReducedModelBrace does not keep track of multi-character braces.");
    }

    public void move(int count) {
        this._cursor.move(count);
    }

    public void delete(int count) {
        if (count == 0) {
            return;
        }
        this._cursor.delete(count);
    }

    private boolean _isCurrentBraceMatchable() {
        return ((ReducedToken)this._cursor.current()).isMatchable();
    }

    public boolean isShadowed() {
        return this._parent.isShadowed();
    }

    public int previousBrace() {
        int dist = 0;
        this.resetWalkerLocationToCursor();
        TokenList.Iterator copyCursor = this._cursor.copy();
        if (!copyCursor.atStart()) {
            copyCursor.prev();
        }
        if (copyCursor.atStart()) {
            copyCursor.dispose();
            return -1;
        }
        int relDistance = dist += this._cursor.getBlockOffset();
        while (!copyCursor.atStart()) {
            if (!((ReducedToken)copyCursor.current()).isGap()) {
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    copyCursor.dispose();
                    return dist + ((ReducedToken)copyCursor.current()).getSize();
                }
                relDistance = 0;
            }
            dist += ((ReducedToken)copyCursor.current()).getSize();
            relDistance += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.prev();
        }
        copyCursor.dispose();
        return -1;
    }

    public int nextBrace() {
        int offset;
        int relDistance = 0;
        int dist = 0;
        TokenList.Iterator copyCursor = this._cursor.copy();
        this.resetWalkerLocationToCursor();
        if (copyCursor.atStart()) {
            copyCursor.next();
        }
        if ((offset = this.getBlockOffset()) > 0) {
            relDistance = dist = ((ReducedToken)copyCursor.current()).getSize() - offset;
            copyCursor.next();
        }
        while (!copyCursor.atEnd()) {
            if (!((ReducedToken)copyCursor.current()).isGap()) {
                if (this.moveWalkerGetState(relDistance) == FREE) {
                    copyCursor.dispose();
                    return dist;
                }
                relDistance = 0;
            }
            relDistance += ((ReducedToken)copyCursor.current()).getSize();
            dist += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.next();
        }
        copyCursor.dispose();
        return -1;
    }

    public int balanceForward() {
        this.resetWalkerLocationToCursor();
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter2 = this._cursor.copy();
        if (!this.openBraceImmediatelyLeft() || this.isShadowed()) {
            iter2.dispose();
            return -1;
        }
        iter2.prev();
        ReducedToken curToken = (ReducedToken)iter2.current();
        assert (curToken instanceof Brace);
        braceStack.push((Brace)curToken);
        iter2.next();
        int relDistance = 0;
        int distance = 0;
        while (!iter2.atEnd() && !braceStack.isEmpty()) {
            curToken = (ReducedToken)iter2.current();
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                ReducedModelState curBraceState = this.moveWalkerGetState(relDistance);
                relDistance = 0;
                if (curBraceState == FREE && !curToken.isCommentStart()) {
                    if (curBrace.isClosedBrace()) {
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter2.dispose();
                            return -1;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
            }
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            iter2.next();
        }
        if (!braceStack.isEmpty()) {
            iter2.dispose();
            return -1;
        }
        iter2.dispose();
        return distance;
    }

    public boolean openBraceImmediatelyLeft() {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return false;
        }
        int offset = this.getBlockOffset();
        this.prev();
        assert (offset == this.getBlockOffset());
        boolean isLeft = this.getBlockOffset() == 0 && this.current().isOpen() && this._isCurrentBraceMatchable();
        this.next();
        return isLeft;
    }

    public boolean closedBraceImmediatelyLeft() {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return false;
        }
        int offset = this.getBlockOffset();
        this.prev();
        assert (offset == this.getBlockOffset());
        boolean isLeft = offset == 0 && this.current().isClosed() && this._isCurrentBraceMatchable();
        this.next();
        return isLeft;
    }

    public int balanceBackward() {
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter2 = this._cursor.copy();
        this.resetWalkerLocationToCursor();
        if (!this.closedBraceImmediatelyLeft() || this.isShadowed()) {
            iter2.dispose();
            return -1;
        }
        int relDistance = 0;
        int distance = 0;
        iter2.prev();
        assert (iter2.current() instanceof Brace);
        do {
            ReducedToken curToken = (ReducedToken)iter2.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                ReducedModelState curBraceState = this.moveWalkerGetState(-relDistance);
                relDistance = 0;
                if (curBraceState == FREE && !curToken.isCommentStart()) {
                    if (curBrace.isOpenBrace()) {
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter2.dispose();
                            return -1;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
            }
            iter2.prev();
        } while (!iter2.atStart() && !braceStack.isEmpty());
        if (!braceStack.isEmpty()) {
            iter2.dispose();
            return -1;
        }
        iter2.dispose();
        return distance;
    }

    protected ReducedModelState moveWalkerGetState(int relDistance) {
        return this._parent.moveWalkerGetState(relDistance);
    }

    protected void resetWalkerLocationToCursor() {
        this._parent.resetLocation();
    }

    public BraceInfo _getLineEnclosingBrace() {
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter2 = this._cursor.copy();
        this.resetWalkerLocationToCursor();
        int distToStart = this._parent.getDistToStart();
        if (distToStart == -1) {
            iter2.dispose();
            return BraceInfo.NULL;
        }
        int relDistance = distToStart + 1;
        int distance = 1;
        iter2.move(-relDistance);
        int offset = iter2.getBlockOffset();
        relDistance += offset;
        distance += offset;
        if (iter2.atStart() || iter2.atFirstItem()) {
            iter2.dispose();
            return BraceInfo.NULL;
        }
        iter2.prev();
        while (!iter2.atStart()) {
            ReducedToken curToken = (ReducedToken)iter2.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                if (this.moveWalkerGetState(-relDistance) == FREE && !curToken.isCommentStart()) {
                    if (curBrace.isOpenBrace()) {
                        if (braceStack.isEmpty()) {
                            String braceType = curBrace.getType();
                            iter2.dispose();
                            return new BraceInfo(braceType, distance);
                        }
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter2.dispose();
                            return BraceInfo.NULL;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
                relDistance = 0;
            }
            iter2.prev();
        }
        iter2.dispose();
        return BraceInfo.NULL;
    }

    protected BraceInfo _getEnclosingBrace() {
        int relDistance;
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter2 = this._cursor.copy();
        this.resetWalkerLocationToCursor();
        int distance = relDistance = 0;
        int offset = iter2.getBlockOffset();
        relDistance += offset;
        distance += offset;
        if (iter2.atStart() || iter2.atFirstItem()) {
            iter2.dispose();
            return BraceInfo.NULL;
        }
        iter2.prev();
        while (!iter2.atStart()) {
            ReducedToken curToken = (ReducedToken)iter2.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                if (this.moveWalkerGetState(-relDistance) == FREE && !curToken.isCommentStart()) {
                    if (curBrace.isOpenBrace()) {
                        if (braceStack.isEmpty()) {
                            String braceType = curBrace.getType();
                            iter2.dispose();
                            return new BraceInfo(braceType, distance);
                        }
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter2.dispose();
                            return BraceInfo.NULL;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
                relDistance = 0;
            }
            iter2.prev();
        }
        iter2.dispose();
        return BraceInfo.NULL;
    }
}

