/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.BooleanOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.compiler.DummyCompilerListener;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitErrorModel;
import edu.rice.cs.drjava.model.junit.JUnitEventNotifier;
import edu.rice.cs.drjava.model.junit.JUnitListener;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVM;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.SimpleBox;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJUnitModel
implements JUnitModel,
JUnitModelCallback {
    private static Log _log = new Log("DefaultJUnitModel.txt", false);
    private final JUnitEventNotifier _notifier = new JUnitEventNotifier();
    private final MainJVM _jvm;
    private final CompilerModel _compilerModel;
    private final GlobalModel _model;
    private volatile JUnitErrorModel _junitErrorModel;
    private volatile boolean _testInProgress = false;
    private boolean _forceTestSuffix = false;
    private final SwingDocument _junitDoc = new SwingDocument();

    public DefaultJUnitModel(MainJVM jvm, CompilerModel compilerModel, GlobalModel model) {
        this._jvm = jvm;
        this._compilerModel = compilerModel;
        this._model = model;
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], this._model, false);
        BooleanOption suffixOption = OptionConstants.FORCE_TEST_SUFFIX;
        this._forceTestSuffix = DrJava.getConfig().getSetting(suffixOption);
    }

    @Override
    public void setForceTestSuffix(boolean b) {
        this._forceTestSuffix = b;
    }

    public boolean isTestInProgress() {
        return this._testInProgress;
    }

    @Override
    public void addListener(JUnitListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(JUnitListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this._notifier.removeAllListeners();
    }

    @Override
    public SwingDocument getJUnitDocument() {
        return this._junitDoc;
    }

    @Override
    public void junitAll() {
        this.junitDocs(this._model.getOpenDefinitionsDocuments());
    }

    @Override
    public void junitProject() {
        LinkedList<OpenDefinitionsDocument> lod = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument doc : this._model.getOpenDefinitionsDocuments()) {
            if (!doc.inProjectPath()) continue;
            lod.add(doc);
        }
        this.junitOpenDefDocs(lod, true);
    }

    @Override
    public void junitDocs(List<OpenDefinitionsDocument> lod) {
        this.junitOpenDefDocs(lod, true);
    }

    @Override
    public void junit(OpenDefinitionsDocument doc) throws ClassNotFoundException, IOException {
        DebugUtil.debug.logStart("junit(doc)");
        try {
            File testFile = doc.getFile();
            if (testFile == null) {
                this.nonTestCase(false, false);
                DebugUtil.debug.logEnd("junit(doc): no corresponding file");
                return;
            }
        }
        catch (FileMovedException fme) {
            // empty catch block
        }
        LinkedList<OpenDefinitionsDocument> lod = new LinkedList<OpenDefinitionsDocument>();
        lod.add(doc);
        this.junitOpenDefDocs(lod, false);
        DebugUtil.debug.logEnd("junit(doc)");
    }

    private void junitOpenDefDocs(final List<OpenDefinitionsDocument> lod, final boolean allTests) {
        if (this._testInProgress) {
            return;
        }
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], null, false);
        List<OpenDefinitionsDocument> outOfSync = this._model.getOutOfSyncDocuments(lod);
        if (outOfSync.size() > 0 || this._model.hasModifiedDocuments(lod)) {
            DummyCompilerListener testAfterCompile = new DummyCompilerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void compileAborted(Exception e) {
                    1 listenerThis = this;
                    try {
                        DefaultJUnitModel.this.nonTestCase(allTests, false);
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(listenerThis){
                            final /* synthetic */ CompilerListener val$listenerThis;
                            {
                                this.val$listenerThis = compilerListener;
                            }

                            public void run() {
                                DefaultJUnitModel.this._compilerModel.removeListener(this.val$listenerThis);
                            }
                        });
                        throw throwable;
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void compileEnded(File workDir, List<? extends File> excludedFiles) {
                    1 listenerThis;
                    block3: {
                        listenerThis = this;
                        try {
                            if (!DefaultJUnitModel.this._model.hasOutOfSyncDocuments(lod) && DefaultJUnitModel.this._model.getNumCompErrors() <= 0) break block3;
                            DefaultJUnitModel.this.nonTestCase(allTests, DefaultJUnitModel.this._model.getNumCompErrors() > 0);
                        }
                        catch (Throwable throwable) {
                            EventQueue.invokeLater(new Runnable(listenerThis){
                                final /* synthetic */ CompilerListener val$listenerThis;
                                {
                                    this.val$listenerThis = compilerListener;
                                }

                                public void run() {
                                    DefaultJUnitModel.this._compilerModel.removeListener(this.val$listenerThis);
                                }
                            });
                            throw throwable;
                        }
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            DefaultJUnitModel.this._rawJUnitOpenDefDocs(lod, allTests);
                        }
                    });
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            this._testInProgress = true;
            this._notifyCompileBeforeJUnit(testAfterCompile, outOfSync);
            this._testInProgress = false;
        } else {
            this._rawJUnitOpenDefDocs(lod, allTests);
        }
    }

    private void _rawJUnitOpenDefDocs(List<OpenDefinitionsDocument> lod, final boolean allTests) {
        File buildDir = this._model.getBuildDirectory();
        HashSet<String> openDocFiles = new HashSet<String>();
        HashMap<File, File> classDirsAndRoots = new HashMap<File, File>();
        for (OpenDefinitionsDocument doc : lod) {
            if (!doc.isSourceFile()) continue;
            try {
                File sourceDir;
                File sourceRoot = doc.getSourceRoot();
                openDocFiles.add(doc.getCanonicalPath());
                String packagePath = doc.getPackageName().replace('.', File.separatorChar);
                File buildRoot = buildDir == FileOps.NULL_FILE ? sourceRoot : buildDir;
                File classFileDir = new File(IOUtil.attemptCanonicalFile(buildRoot), packagePath);
                File file = sourceDir = buildDir == FileOps.NULL_FILE ? classFileDir : new File(IOUtil.attemptCanonicalFile(sourceRoot), packagePath);
                if (classDirsAndRoots.containsKey(classFileDir)) continue;
                classDirsAndRoots.put(classFileDir, sourceDir);
            }
            catch (InvalidPackageException e) {}
        }
        Set classDirs = classDirsAndRoots.keySet();
        final ArrayList classNames = new ArrayList();
        final ArrayList<File> files = new ArrayList<File>();
        boolean isProject = this._model.isProjectActive();
        try {
            for (File dir : classDirs) {
                File[] listing = dir.listFiles();
                if (listing == null) continue;
                for (File entry : listing) {
                    int indexOfLastDot;
                    String noExtName;
                    String simpleClassName;
                    String name = entry.getName();
                    if (!name.endsWith(".class") || this._forceTestSuffix && !(simpleClassName = (noExtName = name.substring(0, name.length() - 6)).substring((indexOfLastDot = noExtName.lastIndexOf(46)) + 1)).endsWith("Test") || !entry.isFile()) continue;
                    try {
                        String sourceFileName;
                        final SimpleBox className = new SimpleBox();
                        final SimpleBox sourceName = new SimpleBox();
                        new ClassReader(IOUtil.toByteArray(entry)).accept(new ClassVisitor(){

                            public void visit(int version, int access, String name, String sig, String sup, String[] inters) {
                                className.set(name.replace('/', '.'));
                            }

                            public void visitSource(String source, String debug) {
                                sourceName.set(source);
                            }

                            public void visitOuterClass(String owner, String name, String desc) {
                            }

                            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                                return null;
                            }

                            public void visitAttribute(Attribute attr) {
                            }

                            public void visitInnerClass(String name, String out, String in, int access) {
                            }

                            public FieldVisitor visitField(int a, String n, String d, String s, Object v) {
                                return null;
                            }

                            public MethodVisitor visitMethod(int a, String n, String d, String s, String[] e) {
                                return null;
                            }

                            public void visitEnd() {
                            }
                        }, 0);
                        File rootDir = (File)classDirsAndRoots.get(dir);
                        String javaSourceFileName = this.getCanonicalPath(rootDir) + File.separator + (String)sourceName.value();
                        int indexOfExtDot = javaSourceFileName.lastIndexOf(46);
                        if (indexOfExtDot == -1) continue;
                        String strippedName = javaSourceFileName.substring(0, indexOfExtDot);
                        if (openDocFiles.contains(javaSourceFileName)) {
                            sourceFileName = javaSourceFileName;
                        } else if (openDocFiles.contains(strippedName + ".dj")) {
                            sourceFileName = strippedName + ".dj";
                        } else if (openDocFiles.contains(strippedName + ".dj0")) {
                            sourceFileName = strippedName + ".dj0";
                        } else if (openDocFiles.contains(strippedName + ".dj1")) {
                            sourceFileName = strippedName + ".dj1";
                        } else {
                            if (!openDocFiles.contains(strippedName + ".dj2")) continue;
                            sourceFileName = strippedName + ".dj2";
                        }
                        File sourceFile = new File(sourceFileName);
                        classNames.add(className.value());
                        files.add(sourceFile);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
        this._testInProgress = true;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = DefaultJUnitModel.this._compilerModel.getCompilerLock();
                synchronized (object) {
                    List tests = DefaultJUnitModel.this._jvm.findTestClasses(classNames, files).unwrap(null);
                    if (tests == null || tests.isEmpty()) {
                        DefaultJUnitModel.this.nonTestCase(allTests, false);
                        return;
                    }
                }
                try {
                    DefaultJUnitModel.this._notifyJUnitStarted();
                    boolean testsPresent = DefaultJUnitModel.this._jvm.runTestSuite();
                    if (!testsPresent) {
                        throw new RemoteException("No unit test classes were passed to the slave JVM");
                    }
                }
                catch (RemoteException e) {
                    DefaultJUnitModel.this._notifyJUnitEnded();
                    DefaultJUnitModel.this._testInProgress = false;
                }
            }
        }).start();
    }

    private void _notifyJUnitStarted() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DefaultJUnitModel.this._notifier.junitStarted();
            }
        });
    }

    private void _notifyJUnitEnded() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DefaultJUnitModel.this._notifier.junitEnded();
            }
        });
    }

    private void _notifyCompileBeforeJUnit(final CompilerListener testAfterCompile, final List<OpenDefinitionsDocument> outOfSync) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultJUnitModel.this._notifier.compileBeforeJUnit(testAfterCompile, outOfSync);
            }
        });
    }

    private void _notifyNonTestCase(final boolean testAll, final boolean didCompileFail) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultJUnitModel.this._notifier.nonTestCase(testAll, didCompileFail);
            }
        });
    }

    private String getCanonicalPath(File f) throws IOException {
        if (f == null) {
            return "";
        }
        return f.getCanonicalPath();
    }

    @Override
    public JUnitErrorModel getJUnitErrorModel() {
        return this._junitErrorModel;
    }

    @Override
    public void resetJUnitErrors() {
        this._junitErrorModel = new JUnitErrorModel(new JUnitError[0], this._model, false);
    }

    @Override
    public void nonTestCase(boolean isTestAll, boolean didCompileFail) {
        this._notifyNonTestCase(isTestAll, didCompileFail);
        this._testInProgress = false;
    }

    @Override
    public void classFileError(final ClassFileError e) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultJUnitModel.this._notifier.classFileError(e);
            }
        });
    }

    @Override
    public void testSuiteStarted(final int numTests) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultJUnitModel.this._notifier.junitSuiteStarted(numTests);
            }
        });
    }

    @Override
    public void testStarted(final String testName) {
        Utilities.invokeLater(new Runnable(){

            public void run() {
                DefaultJUnitModel.this._notifier.junitTestStarted(testName);
            }
        });
    }

    @Override
    public void testEnded(final String testName, final boolean wasSuccessful, final boolean causedError) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DefaultJUnitModel.this._notifier.junitTestEnded(testName, wasSuccessful, causedError);
            }
        });
    }

    @Override
    public void testSuiteEnded(JUnitError[] errors) {
        ArrayList<File> files = new ArrayList<File>();
        for (OpenDefinitionsDocument odd : this._model.getLLOpenDefinitionsDocuments()) {
            files.add(odd.getRawFile());
        }
        for (JUnitError e : errors) {
            try {
                e.setStackTrace(this._compilerModel.getLLSTM().replaceStackTrace(e.stackTrace(), files));
            }
            catch (Exception ex) {
                DrJavaErrorHandler.record(ex);
            }
            File f = e.file();
            if (f == null || !DrJavaFileUtils.isLLFile(f)) continue;
            String dn = DrJavaFileUtils.getJavaForLLFile(f.getName());
            StackTraceElement ste = new StackTraceElement(e.className(), "", dn, e.lineNumber());
            ste = this._compilerModel.getLLSTM().replaceStackTraceElement(ste, f);
            e.setLineNumber(ste.getLineNumber());
        }
        this._junitErrorModel = new JUnitErrorModel(errors, this._model, true);
        this._notifyJUnitEnded();
        this._testInProgress = false;
    }

    @Override
    public File getFileForClassName(String className) {
        return this._model.getSourceFile(className + ".java");
    }

    @Override
    public Iterable<File> getClassPath() {
        return this._jvm.getClassPath().unwrap(IterUtil.empty());
    }

    @Override
    public void junitJVMReady() {
        if (!this._testInProgress) {
            return;
        }
        JUnitError[] errors = new JUnitError[]{new JUnitError("Previous test suite was interrupted", true, "")};
        this._junitErrorModel = new JUnitErrorModel(errors, this._model, true);
        this._notifyJUnitEnded();
        this._testInProgress = false;
    }
}

