/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbortablePanel
extends TabbedPanel {
    protected JPanel _leftPane;
    protected JScrollPane _scrollPane;
    protected final SingleDisplayModel _model;
    protected final MainFrame _frame;
    protected String _title;
    protected JPanel _buttonPanel;
    protected JButton _abortButton;

    public AbortablePanel(MainFrame frame, String title) {
        super(frame, title);
        this._title = title;
        this.setLayout(new BorderLayout());
        this._frame = frame;
        this._model = frame.getModel();
        this.removeAll();
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "North");
        this._leftPane = new JPanel(new BorderLayout());
        Component leftPanel = this.makeLeftPanel();
        this._scrollPane = new JScrollPane(leftPanel);
        this._leftPane.add(this._scrollPane);
        AbortablePanel._setColors(leftPanel);
        this.add((Component)this._leftPane, "Center");
        this._buttonPanel = new JPanel(new BorderLayout());
        this._setupButtonPanel();
        this.add((Component)this._buttonPanel, "East");
        this.updateButtons();
    }

    protected static void _setColors(Component c) {
        new ForegroundColorListener(c);
        new BackgroundColorListener(c);
    }

    protected void _close() {
        super._close();
        this.abortActionPerformed(null);
        this.updateButtons();
    }

    protected abstract Component makeLeftPanel();

    protected abstract void abortActionPerformed(ActionEvent var1);

    protected void updateButtons() {
    }

    protected JComponent[] makeButtons() {
        return new JComponent[0];
    }

    private void _setupButtonPanel() {
        JPanel mainButtons = new JPanel();
        JPanel emptyPanel = new JPanel();
        JPanel closeButtonPanel = new JPanel(new BorderLayout());
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        mainButtons.setLayout(gbLayout);
        JComponent[] buts = this.makeButtons();
        closeButtonPanel.add((Component)this._closeButton, "North");
        this._abortButton = new JButton("Abort");
        mainButtons.add(this._abortButton);
        this._abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbortablePanel.this.abortActionPerformed(e);
            }
        });
        for (JComponent b : buts) {
            mainButtons.add(b);
        }
        mainButtons.add(emptyPanel);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weightx = 1.0;
        gbLayout.setConstraints(this._abortButton, c);
        for (JComponent b : buts) {
            gbLayout.setConstraints(b, c);
        }
        c.fill = 1;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 1.0;
        gbLayout.setConstraints(emptyPanel, c);
        this._buttonPanel.add((Component)mainButtons, "Center");
        this._buttonPanel.add((Component)closeButtonPanel, "East");
    }
}

