/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RegionsTreePanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksPanel
extends RegionsTreePanel<MovingDocumentRegion> {
    protected JButton _goToButton;
    protected JButton _removeButton;
    protected JButton _removeAllButton;

    public BookmarksPanel(MainFrame frame, RegionManager<MovingDocumentRegion> bookmarkManager) {
        super(frame, "Bookmarks", bookmarkManager);
        this._regionManager.addListener(new RegionManagerListener<MovingDocumentRegion>(){

            @Override
            public void regionAdded(MovingDocumentRegion r) {
                BookmarksPanel.this.addRegion(r);
            }

            @Override
            public void regionChanged(MovingDocumentRegion r) {
                this.regionRemoved(r);
                this.regionAdded(r);
            }

            @Override
            public void regionRemoved(MovingDocumentRegion r) {
                BookmarksPanel.this.removeRegion(r);
            }
        });
    }

    @Override
    protected void performDefaultAction() {
        this.goToRegion();
    }

    @Override
    protected JComponent[] makeButtons() {
        AbstractAction goToAction = new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent ae) {
                BookmarksPanel.this.goToRegion();
            }
        };
        this._goToButton = new JButton(goToAction);
        AbstractAction removeAction = new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ae) {
                BookmarksPanel.this._remove();
            }
        };
        this._removeButton = new JButton(removeAction);
        AbstractAction removeAllAction = new AbstractAction("Remove All"){

            public void actionPerformed(ActionEvent ae) {
                BookmarksPanel.this._regionManager.clearRegions();
            }
        };
        this._removeAllButton = new JButton(removeAllAction);
        JComponent[] buts = new JComponent[]{this._goToButton, this._removeButton, this._removeAllButton};
        return buts;
    }

    @Override
    protected void _updateButtons() {
        ArrayList regs = this.getSelectedRegions();
        this._goToButton.setEnabled(regs.size() == 1);
        this._removeButton.setEnabled(regs.size() > 0);
        this._removeAllButton.setEnabled(this._rootNode != null && this._rootNode.getDepth() > 0);
    }

    @Override
    protected AbstractAction[] makePopupMenuActions() {
        AbstractAction[] acts = new AbstractAction[]{new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent e) {
                BookmarksPanel.this.goToRegion();
            }
        }, new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                for (MovingDocumentRegion r : BookmarksPanel.this.getSelectedRegions()) {
                    BookmarksPanel.this._regionManager.removeRegion(r);
                }
            }
        }};
        return acts;
    }
}

