/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.ClipboardHistoryModel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClipboardHistoryFrame
extends SwingFrame {
    private ClipboardHistoryModel _chm;
    private int _buttonPressed;
    private JButton _okButton;
    private JButton _cancelButton;
    private JList _historyList;
    private JTextArea _previewArea;
    private FrameState _lastState = null;
    private MainFrame _mainFrame;
    private CloseAction _okAction;
    private CloseAction _cancelAction;
    protected WindowAdapter _windowListener = new WindowAdapter(){

        public void windowDeactivated(WindowEvent we) {
            ClipboardHistoryFrame.this.toFront();
        }

        public void windowClosing(WindowEvent we) {
            ClipboardHistoryFrame.this.cancelButtonPressed();
        }
    };

    public ClipboardHistoryFrame(MainFrame owner, String title, ClipboardHistoryModel chm, CloseAction okAction, CloseAction cancelAction) {
        super(title);
        this._chm = chm;
        this._mainFrame = owner;
        this._okAction = okAction;
        this._cancelAction = cancelAction;
        this.init();
        this.initDone();
    }

    public FrameState getFrameState() {
        return this._lastState;
    }

    public void setFrameState(FrameState ds) {
        this._lastState = ds;
        if (this._lastState != null) {
            this.setSize(this._lastState.getDimension());
            this.setLocation(this._lastState.getLocation());
            this.validate();
        }
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
        if (this._lastState != null) {
            this.setSize(this._lastState.getDimension());
            this.setLocation(this._lastState.getLocation());
            this.validate();
        } else {
            Dimension parentDim = this._mainFrame != null ? this._mainFrame.getSize() : this.getToolkit().getScreenSize();
            int xs = (int)parentDim.getWidth() / 3;
            int ys = (int)parentDim.getHeight() / 4;
            this.setSize(Math.max(xs, 400), Math.max(ys, 400));
            Utilities.setPopupLoc(this, this._mainFrame);
        }
    }

    public int getButtonPressed() {
        return this._buttonPressed;
    }

    private void init() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ClipboardHistoryFrame.this.validate();
                ClipboardHistoryFrame.this._historyList.ensureIndexIsVisible(ClipboardHistoryFrame.this._historyList.getSelectedIndex());
            }
        });
        JRootPane rootPane = this.getRootPane();
        InputMap iMap = rootPane.getInputMap(1);
        iMap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap aMap = rootPane.getActionMap();
        aMap.put("escape", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ClipboardHistoryFrame.this.cancelButtonPressed();
            }
        });
        this._historyList = new JList();
        this._historyList.setSelectionMode(0);
        this._historyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ClipboardHistoryFrame.this.updatePreview();
            }
        });
        this._historyList.setFont(DrJava.getConfig().getSetting(OptionConstants.FONT_MAIN));
        this._historyList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                c.setForeground(DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR));
                return c;
            }
        });
        this._historyList.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != ClipboardHistoryFrame.this._previewArea && e.getOppositeComponent() != ClipboardHistoryFrame.this._okButton && e.getOppositeComponent() != ClipboardHistoryFrame.this._cancelButton) {
                    ClipboardHistoryFrame.this._historyList.requestFocus();
                }
            }
        });
        this._okButton = new JButton("OK");
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClipboardHistoryFrame.this.okButtonPressed();
            }
        });
        this._cancelButton = new JButton("Cancel");
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClipboardHistoryFrame.this.cancelButtonPressed();
            }
        });
        Container contentPane = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets.top = 2;
        c.insets.left = 2;
        c.insets.bottom = 2;
        c.insets.right = 2;
        c.fill = 1;
        c.weighty = 1.0;
        contentPane.add((Component)new JScrollPane(this._historyList, 20, 30), c);
        this._previewArea = new JTextArea("");
        this._previewArea.setEditable(false);
        this._previewArea.setDragEnabled(false);
        this._previewArea.setEnabled(false);
        this._previewArea.setFont(DrJava.getConfig().getSetting(OptionConstants.FONT_MAIN));
        this._previewArea.setDisabledTextColor(DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR));
        c.weighty = 2.0;
        contentPane.add((Component)new JScrollPane(this._previewArea, 20, 30), c);
        c.anchor = 15;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints bc = new GridBagConstraints();
        bc.insets.left = 2;
        bc.insets.right = 2;
        buttonPanel.add((Component)this._okButton, bc);
        buttonPanel.add((Component)this._cancelButton, bc);
        c.weighty = 0.0;
        contentPane.add((Component)buttonPanel, c);
        Dimension parentDim = this._mainFrame != null ? this._mainFrame.getSize() : this.getToolkit().getScreenSize();
        int xs = (int)parentDim.getWidth() / 3;
        int ys = (int)parentDim.getHeight() / 4;
        this.setSize(Math.max(xs, 400), Math.max(ys, 300));
        Utilities.setPopupLoc(this, this._mainFrame);
        this.updateView();
    }

    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this.updateView();
            this._historyList.requestFocus();
            this.toFront();
        } else {
            this.removeWindowFocusListener(this._windowListener);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    private void updateView() {
        List<String> strs = this._chm.getStrings();
        ListItem[] arr = new ListItem[strs.size()];
        for (int i = 0; i < strs.size(); ++i) {
            arr[strs.size() - i - 1] = new ListItem(strs.get(i));
        }
        this._historyList.setListData(arr);
        if (this._historyList.getModel().getSize() > 0) {
            this._historyList.setSelectedIndex(0);
            this.getRootPane().setDefaultButton(this._okButton);
            this._okButton.setEnabled(true);
        } else {
            this.getRootPane().setDefaultButton(this._cancelButton);
            this._okButton.setEnabled(false);
        }
        this.updatePreview();
    }

    private void updatePreview() {
        int index;
        String text = "";
        if (this._historyList.getModel().getSize() > 0 && (index = this._historyList.getSelectedIndex()) != -1) {
            text = ((ListItem)this._historyList.getModel().getElementAt(this._historyList.getSelectedIndex())).getFull();
        }
        this._previewArea.setText(text);
        this._previewArea.setCaretPosition(0);
    }

    private void okButtonPressed() {
        this._lastState = new FrameState(this);
        this.setVisible(false);
        if (this._historyList.getModel().getSize() > 0) {
            this._buttonPressed = 0;
            String s = ((ListItem)this._historyList.getModel().getElementAt(this._historyList.getSelectedIndex())).getFull();
            this._chm.put(s);
            this._okAction.value(s);
        } else {
            this._buttonPressed = 2;
            Toolkit.getDefaultToolkit().beep();
            this._cancelAction.value(null);
        }
    }

    private void cancelButtonPressed() {
        this._buttonPressed = 2;
        this._lastState = new FrameState(this);
        this.setVisible(false);
        this._cancelAction.value(null);
    }

    private static class ListItem {
        private String full;
        private String display;

        public ListItem(String s) {
            int index2;
            this.full = s;
            int index1 = s.indexOf(10);
            if (index1 == -1) {
                index1 = s.length();
            }
            if ((index2 = s.indexOf(StringOps.EOL)) == -1) {
                index2 = s.length();
            }
            this.display = s.substring(0, Math.min(index1, index2));
        }

        public String getFull() {
            return this.full;
        }

        public String toString() {
            return this.display;
        }
    }

    public static class FrameState {
        private Dimension _dim;
        private Point _loc;

        public FrameState(Dimension d, Point l) {
            this._dim = d;
            this._loc = l;
        }

        public FrameState(String s) {
            StringTokenizer tok = new StringTokenizer(s);
            try {
                int x = Integer.valueOf(tok.nextToken());
                int y = Integer.valueOf(tok.nextToken());
                this._dim = new Dimension(x, y);
                x = Integer.valueOf(tok.nextToken());
                y = Integer.valueOf(tok.nextToken());
                this._loc = new Point(x, y);
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nsee);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nfe);
            }
        }

        public FrameState(ClipboardHistoryFrame comp) {
            this._dim = comp.getSize();
            this._loc = comp.getLocation();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((int)this._dim.getWidth());
            sb.append(' ');
            sb.append((int)this._dim.getHeight());
            sb.append(' ');
            sb.append(this._loc.x);
            sb.append(' ');
            sb.append(this._loc.y);
            return sb.toString();
        }

        public Dimension getDimension() {
            return this._dim;
        }

        public Point getLocation() {
            return this._loc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CloseAction
    extends Lambda<String, Object> {
    }
}

