/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.dynamicjava.symbol.type.VariableType;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.tuple.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeBindings {
    public static final RuntimeBindings EMPTY = new RuntimeBindings();
    private final RuntimeBindings _parent;
    private final Map<LocalVariable, Object> _vars;
    private final Map<VariableType, Type> _tvars;
    private final Map<DJClass, Object> _thisVals;

    public RuntimeBindings(RuntimeBindings parent, Map<LocalVariable, Object> vars, Map<VariableType, Type> tvars, Map<DJClass, Object> thisVals) {
        this._parent = parent;
        this._vars = new HashMap<LocalVariable, Object>(vars);
        this._tvars = new HashMap<VariableType, Type>(tvars);
        this._thisVals = new HashMap<DJClass, Object>(thisVals);
    }

    private RuntimeBindings() {
        this(null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    public RuntimeBindings(RuntimeBindings parent, LocalVariable var, Object val) {
        this(parent, Collections.singletonMap(var, val), Collections.emptyMap(), Collections.emptyMap());
    }

    public RuntimeBindings(RuntimeBindings parent, Iterable<LocalVariable> vars, Iterable<Object> vals) {
        this(parent, RuntimeBindings.makeMap(vars, vals), Collections.emptyMap(), Collections.emptyMap());
    }

    private static <K, V> Map<K, V> makeMap(Iterable<? extends K> keys, Iterable<? extends V> vals) {
        HashMap result = new HashMap();
        for (Pair pair : IterUtil.zip(keys, vals)) {
            result.put(pair.first(), pair.second());
        }
        return result;
    }

    public RuntimeBindings(RuntimeBindings parent, DJClass thisClass, Object thisObj) {
        this(parent, Collections.emptyMap(), Collections.emptyMap(), Collections.singletonMap(thisClass, thisObj));
    }

    public Object get(LocalVariable v) {
        if (this._vars.containsKey(v)) {
            return this._vars.get(v);
        }
        if (this._parent != null) {
            return this._parent.get(v);
        }
        throw new IllegalArgumentException("Variable " + v + " is undefined");
    }

    public void set(LocalVariable v, Object val) {
        if (this._vars.containsKey(v)) {
            this._vars.put(v, val);
        } else if (this._parent != null) {
            this._parent.set(v, val);
        } else {
            throw new IllegalArgumentException("Variable " + v + " is undefined");
        }
    }

    public Type get(VariableType v) {
        if (this._tvars.containsKey(v)) {
            return this._tvars.get(v);
        }
        if (this._parent != null) {
            return this._parent.get(v);
        }
        throw new IllegalArgumentException("Type variable " + v + " is undefined");
    }

    public Object getThis(DJClass c) {
        if (this._thisVals.containsKey(c)) {
            return this._thisVals.get(c);
        }
        if (this._parent != null) {
            return this._parent.getThis(c);
        }
        throw new IllegalArgumentException("This value " + c + " is undefined");
    }
}

