/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.ExpressionEvaluator;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.tuple.Option;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionStatement;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementEvaluator
extends AbstractVisitor<Result> {
    private final RuntimeBindings _bindings;
    private final Options _opt;

    public StatementEvaluator(RuntimeBindings bindings, Options opt) {
        this._bindings = bindings;
        this._opt = opt;
    }

    public Result evaluateSequence(Iterable<? extends Node> nodes) {
        Result result = new Result(this._bindings);
        for (Node node : nodes) {
            result = node.acceptVisitor(new StatementEvaluator(result.bindings(), this._opt));
        }
        return result;
    }

    @Override
    public Result visit(PackageDeclaration node) {
        return new Result(this._bindings);
    }

    @Override
    public Result visit(ImportDeclaration node) {
        return new Result(this._bindings);
    }

    @Override
    public Result visit(ClassDeclaration node) {
        return new Result(this._bindings);
    }

    @Override
    public Result visit(InterfaceDeclaration node) {
        return new Result(this._bindings);
    }

    @Override
    public Result visit(ConstructorDeclaration node) {
        return new Result(this._bindings);
    }

    @Override
    public Result visit(MethodDeclaration node) {
        return new Result(this._bindings);
    }

    @Override
    public Result visit(VariableDeclaration node) {
        Object init = SymbolUtil.initialValue(NodeProperties.getErasedType(node).value());
        RuntimeBindings newB = new RuntimeBindings(this._bindings, NodeProperties.getVariable(node), init);
        if (node.getInitializer() != null) {
            newB.set(NodeProperties.getVariable(node), new ExpressionEvaluator(newB, this._opt).value(node.getInitializer()));
        }
        return new Result(newB);
    }

    @Override
    public Result visit(EmptyStatement node) {
        return new Result(this._bindings);
    }

    @Override
    public Result visit(ExpressionStatement node) {
        if (NodeProperties.hasStatementTranslation(node)) {
            return NodeProperties.getStatementTranslation(node).acceptVisitor(this);
        }
        Object val = new ExpressionEvaluator(this._bindings, this._opt).value(node.getExpression());
        if (node.getHasSemicolon() || NodeProperties.getType(node.getExpression()).equals(TypeSystem.VOID)) {
            return new Result(this._bindings);
        }
        return new Result(val, this._bindings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result visit(WhileStatement node) {
        ExpressionEvaluator eval = new ExpressionEvaluator(this._bindings, this._opt);
        try {
            while (((Boolean)eval.value(node.getCondition())).booleanValue()) {
                try {
                    node.getBody().acceptVisitor(this);
                }
                catch (ContinueException e) {
                    if (!e.hasLabel() || node.hasLabel(e.label())) continue;
                    throw e;
                    return new Result(this._bindings);
                }
            }
        }
        catch (BreakException e) {
            if (!e.hasLabel() || node.hasLabel(e.label())) return new Result(this._bindings);
            throw e;
        }
    }

    @Override
    public Result visit(ForEachStatement node) {
        Iterator<Object> iter2;
        LocalVariable param = NodeProperties.getVariable(node.getParameter());
        RuntimeBindings newB = new RuntimeBindings(this._bindings, param, null);
        final Object iterable = new ExpressionEvaluator(newB, this._opt).value(node.getCollection());
        if (iterable == null) {
            throw new WrappedException(new EvaluatorException(new NullPointerException()));
        }
        if (iterable.getClass().isArray()) {
            final int length = Array.getLength(iterable);
            iter2 = new ReadOnlyIterator<Object>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < length;
                }

                @Override
                public Object next() {
                    try {
                        return Array.get(iterable, this.i++);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new WrappedException(new EvaluatorException(e));
                    }
                }
            };
        } else {
            try {
                Method getIterator = iterable.getClass().getMethod("iterator", new Class[0]);
                try {
                    getIterator.setAccessible(true);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                iter2 = (Iterator)getIterator.invoke(iterable, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new WrappedException(new EvaluatorException(e.getCause()));
            }
        }
        StatementEvaluator seval = new StatementEvaluator(newB, this._opt);
        block12: while (true) {
            try {
                while (true) {
                    Object elt;
                    try {
                        if (!iter2.hasNext()) break block12;
                        elt = iter2.next();
                    }
                    catch (Throwable t) {
                        throw new WrappedException(new EvaluatorException(t));
                    }
                    try {
                        newB.set(param, elt);
                        node.getBody().acceptVisitor(seval);
                        continue block12;
                    }
                    catch (ContinueException e) {
                        if (!e.hasLabel() || node.hasLabel(e.label())) continue;
                        throw e;
                    }
                    break;
                }
            }
            catch (BreakException e) {
                if (!e.hasLabel() || node.hasLabel(e.label())) break;
                throw e;
            }
        }
        return new Result(this._bindings);
    }

    @Override
    public Result visit(ForStatement node) {
        block7: {
            RuntimeBindings newB = this._bindings;
            if (node.getInitialization() != null) {
                newB = this.evaluateSequence(node.getInitialization()).bindings();
            }
            Expression cond = node.getCondition();
            List<Node> update = node.getUpdate();
            ExpressionEvaluator eval = new ExpressionEvaluator(newB, this._opt);
            StatementEvaluator seval = new StatementEvaluator(newB, this._opt);
            try {
                while (cond == null || ((Boolean)eval.value(cond)).booleanValue()) {
                    block6: {
                        try {
                            node.getBody().acceptVisitor(seval);
                        }
                        catch (ContinueException e) {
                            if (!e.hasLabel() || node.hasLabel(e.label())) break block6;
                            throw e;
                        }
                    }
                    if (update == null) continue;
                    seval.evaluateSequence(update);
                }
            }
            catch (BreakException e) {
                if (!e.hasLabel() || node.hasLabel(e.label())) break block7;
                throw e;
            }
        }
        return new Result(this._bindings);
    }

    @Override
    public Result visit(DoStatement node) {
        block5: {
            ExpressionEvaluator eval = new ExpressionEvaluator(this._bindings, this._opt);
            try {
                do {
                    try {
                        node.getBody().acceptVisitor(this);
                    }
                    catch (ContinueException e) {
                        if (!e.hasLabel() || node.hasLabel(e.label())) continue;
                        throw e;
                    }
                } while (((Boolean)eval.value(node.getCondition())).booleanValue());
            }
            catch (BreakException e) {
                if (!e.hasLabel() || node.hasLabel(e.label())) break block5;
                throw e;
            }
        }
        return new Result(this._bindings);
    }

    @Override
    public Result visit(SwitchStatement node) {
        block6: {
            ExpressionEvaluator eval = new ExpressionEvaluator(this._bindings, this._opt);
            Object sel = eval.value(node.getSelector());
            Iterator<SwitchBlock> body = node.getBindings().iterator();
            for (SwitchBlock block : node.getBindings()) {
                if (block.getExpression() != null && eval.value(block.getExpression()).equals(sel)) break;
                body.next();
            }
            if (!body.hasNext()) {
                body = node.getBindings().iterator();
                for (SwitchBlock block : node.getBindings()) {
                    if (block.getExpression() == null) break;
                    body.next();
                }
            }
            AbstractIterable toEvaluate = IterUtil.empty();
            while (body.hasNext()) {
                toEvaluate = IterUtil.compose(toEvaluate, body.next().getStatements());
            }
            try {
                this.evaluateSequence(toEvaluate);
            }
            catch (BreakException e) {
                if (!e.hasLabel()) break block6;
                throw e;
            }
        }
        return new Result(this._bindings);
    }

    @Override
    public Result visit(LabeledStatement node) {
        block2: {
            try {
                node.getStatement().acceptVisitor(this);
            }
            catch (BreakException e) {
                if (e.hasLabel() && e.label().equals(node.getLabel())) break block2;
                throw e;
            }
        }
        return new Result(this._bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result visit(SynchronizedStatement node) {
        Object object = new ExpressionEvaluator(this._bindings, this._opt).value(node.getLock());
        synchronized (object) {
            node.getBody().acceptVisitor(this);
        }
        return new Result(this._bindings);
    }

    @Override
    public Result visit(BreakStatement node) {
        if (node.getLabel() == null) {
            throw new BreakException();
        }
        throw new BreakException(node.getLabel());
    }

    @Override
    public Result visit(ContinueStatement node) {
        if (node.getLabel() == null) {
            throw new ContinueException();
        }
        throw new ContinueException(node.getLabel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result visit(TryStatement node) {
        block9: {
            try {
                node.getTryBlock().acceptVisitor(this);
            }
            catch (WrappedException e) {
                if (e.getCause() instanceof EvaluatorException) {
                    Throwable t = e.getCause().getCause();
                    boolean handled = false;
                    for (CatchStatement cs : node.getCatchStatements()) {
                        if (!NodeProperties.getErasedType(cs).value().isInstance(t)) continue;
                        handled = true;
                        RuntimeBindings newB = new RuntimeBindings(this._bindings, NodeProperties.getVariable(cs.getException()), (Object)t);
                        cs.getBlock().acceptVisitor(new StatementEvaluator(newB, this._opt));
                        break;
                    }
                    if (!handled) {
                        throw e;
                    }
                    break block9;
                }
                throw e;
            }
            finally {
                if (node.getFinallyBlock() != null) {
                    node.getFinallyBlock().acceptVisitor(this);
                }
            }
        }
        return new Result(this._bindings);
    }

    @Override
    public Result visit(ThrowStatement node) {
        Throwable t = (Throwable)new ExpressionEvaluator(this._bindings, this._opt).value(node.getExpression());
        if (t == null) {
            t = new NullPointerException();
            t.setStackTrace(new StackTraceElement[0]);
        }
        throw new WrappedException(new EvaluatorException(t));
    }

    @Override
    public Result visit(ReturnStatement node) {
        if (node.getExpression() == null) {
            throw new ReturnException();
        }
        Object result = new ExpressionEvaluator(this._bindings, this._opt).value(node.getExpression());
        throw new ReturnException(result);
    }

    @Override
    public Result visit(IfThenStatement node) {
        if (((Boolean)new ExpressionEvaluator(this._bindings, this._opt).value(node.getCondition())).booleanValue()) {
            node.getThenStatement().acceptVisitor(this);
        }
        return new Result(this._bindings);
    }

    @Override
    public Result visit(IfThenElseStatement node) {
        if (((Boolean)new ExpressionEvaluator(this._bindings, this._opt).value(node.getCondition())).booleanValue()) {
            node.getThenStatement().acceptVisitor(this);
        } else {
            node.getElseStatement().acceptVisitor(this);
        }
        return new Result(this._bindings);
    }

    @Override
    public Result visit(AssertStatement node) {
        String message;
        ExpressionEvaluator eval = new ExpressionEvaluator(this._bindings, this._opt);
        if (((Boolean)eval.value(node.getCondition())).booleanValue()) {
            return new Result(this._bindings);
        }
        if (node.getFailString() == null) {
            throw new WrappedException(new EvaluatorException((Throwable)((Object)new AssertionError())));
        }
        Object messageObj = eval.value(node.getFailString());
        try {
            message = messageObj.toString();
        }
        catch (Throwable t) {
            throw new WrappedException(new EvaluatorException(t));
        }
        throw new WrappedException(new EvaluatorException((Throwable)((Object)new AssertionError((Object)message))));
    }

    @Override
    public Result visit(BlockStatement node) {
        return this.evaluateSequence(node.getStatements());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReturnException
    extends ControlFlowException {
        private final Option<Object> _value;

        public ReturnException() {
            this._value = Option.none();
        }

        public ReturnException(Object value) {
            this._value = Option.some(value);
        }

        public Option<Object> value() {
            return this._value;
        }
    }

    public static class BreakException
    extends LabelControlException {
        public BreakException() {
        }

        public BreakException(String label) {
            super(label);
        }
    }

    public static class ContinueException
    extends LabelControlException {
        public ContinueException() {
        }

        public ContinueException(String label) {
            super(label);
        }
    }

    public static class LabelControlException
    extends ControlFlowException {
        private final String _label;

        public LabelControlException() {
            this._label = null;
        }

        public LabelControlException(String label) {
            this._label = label;
        }

        public boolean hasLabel() {
            return this._label != null;
        }

        public String label() {
            return this._label;
        }
    }

    public static class ControlFlowException
    extends RuntimeException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result {
        private Option<Object> _val;
        private RuntimeBindings _bindings;

        public Result(Object val, RuntimeBindings b) {
            this._val = Option.some(val);
            this._bindings = b;
        }

        public Result(RuntimeBindings b) {
            this._val = Option.none();
            this._bindings = b;
        }

        public Option<Object> value() {
            return this._val;
        }

        public RuntimeBindings bindings() {
            return this._bindings;
        }
    }
}

