/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BodyBodyIntermediateVisitor;
import edu.rice.cs.javalanglevels.IntermediateVisitor;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.MethodData;
import edu.rice.cs.javalanglevels.Pair;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.AbstractMethodDef;
import edu.rice.cs.javalanglevels.tree.ComplexAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.ConcreteMethodDef;
import edu.rice.cs.javalanglevels.tree.ConstructorDef;
import edu.rice.cs.javalanglevels.tree.InnerClassDef;
import edu.rice.cs.javalanglevels.tree.InnerInterfaceDef;
import edu.rice.cs.javalanglevels.tree.InstanceInitializer;
import edu.rice.cs.javalanglevels.tree.SimpleAnonymousClassInstantiation;
import edu.rice.cs.javalanglevels.tree.Statement;
import edu.rice.cs.javalanglevels.tree.TypeParameter;
import edu.rice.cs.javalanglevels.tree.VariableDeclaration;
import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBodyIntermediateVisitor
extends IntermediateVisitor {
    private SymbolData _classData;

    public ClassBodyIntermediateVisitor(SymbolData sd, File file, String packageName, LinkedList<String> importedFiles, LinkedList<String> importedPackages, LinkedList<String> classDefsInThisFile, Hashtable<String, Pair<SourceInfo, LanguageLevelVisitor>> continuations) {
        super(file, packageName, importedFiles, importedPackages, classDefsInThisFile, continuations);
        this._classData = sd;
    }

    @Override
    public Void forStatementDoFirst(Statement that) {
        ClassBodyIntermediateVisitor._addError("Statements cannot appear outside of method bodies", that);
        return null;
    }

    @Override
    public Void forAbstractMethodDefDoFirst(AbstractMethodDef that) {
        if (!this._classData.isInterface() && !this._classData.hasModifier("abstract")) {
            ClassBodyIntermediateVisitor._addError("Abstract methods can only be declared in abstract classes", that);
        }
        return super.forAbstractMethodDefDoFirst(that);
    }

    @Override
    public Void forInstanceInitializerDoFirst(InstanceInitializer that) {
        ClassBodyIntermediateVisitor._addError("This open brace must mark the beginning of a method or class body", that);
        return null;
    }

    @Override
    public Void forVariableDeclarationOnly(VariableDeclaration that) {
        VariableData[] vds = this._variableDeclaration2VariableData(that, this._classData);
        for (int i = 0; i < vds.length; ++i) {
            if (vds[i].isStatic()) continue;
            vds[i].setPrivate();
        }
        if (!this._classData.addFinalVars(vds)) {
            ClassBodyIntermediateVisitor._addAndIgnoreError("You cannot have two fields with the same name.  Either you already have a field by that name in this class, or one of your superclasses or interfaces has a field by that name", that);
        }
        return null;
    }

    @Override
    public Void forInnerInterfaceDef(InnerInterfaceDef that) {
        String innerClassName = this.getQualifiedClassName(this._classData.getName()) + "." + that.getName().getText();
        this.handleInnerInterfaceDef(that, this._classData, innerClassName);
        return null;
    }

    @Override
    public Void forInnerClassDef(InnerClassDef that) {
        String innerClassName = this.getQualifiedClassName(this._classData.getName()) + "." + that.getName().getText();
        this.handleInnerClassDef(that, this._classData, innerClassName);
        return null;
    }

    @Override
    public Void forConcreteMethodDef(ConcreteMethodDef that) {
        String className;
        this.forConcreteMethodDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        MethodData md = this.createMethodData(that, this._classData);
        if (!(md.hasModifier("public") || md.hasModifier("private") || md.hasModifier("protected"))) {
            md.addModifier("public");
        }
        if ((className = ClassBodyIntermediateVisitor.getUnqualifiedClassName(this._classData.getName())).equals(md.getName())) {
            ClassBodyIntermediateVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors do not have an explicit return type", that);
        } else {
            this._classData.addMethod(md);
        }
        that.getBody().visit(new BodyBodyIntermediateVisitor(md, this._file, this._package, this._importedFiles, this._importedPackages, this._classNamesInThisFile, continuations, this._innerClassesToBeParsed));
        return this.forConcreteMethodDefOnly(that);
    }

    @Override
    public Void forAbstractMethodDef(AbstractMethodDef that) {
        String className;
        this.forAbstractMethodDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        MethodData md = this.createMethodData(that, this._classData);
        if (!(md.hasModifier("public") || md.hasModifier("private") || md.hasModifier("protected"))) {
            md.addModifier("public");
        }
        if ((className = ClassBodyIntermediateVisitor.getUnqualifiedClassName(this._classData.getName())).equals(md.getName())) {
            ClassBodyIntermediateVisitor._addAndIgnoreError("Only constructors can have the same name as the class they appear in, and constructors do not have an explicit return type", that);
        } else {
            this._classData.addMethod(md);
        }
        return null;
    }

    @Override
    public Void forConstructorDef(ConstructorDef that) {
        this.forConstructorDefDoFirst(that);
        if (this.prune(that)) {
            return null;
        }
        that.getMav().visit(this);
        String name = ClassBodyIntermediateVisitor.getUnqualifiedClassName(that.getName().getText());
        if (!name.equals(ClassBodyIntermediateVisitor.getUnqualifiedClassName(this._classData.getName()))) {
            ClassBodyIntermediateVisitor._addAndIgnoreError("The constructor return type and class name must match", that);
        }
        String[] throwStrings = this.referenceType2String(that.getThrows());
        SymbolData returnType = this._classData;
        MethodData md = new MethodData(name, that.getMav(), new TypeParameter[0], returnType, new VariableData[0], throwStrings, this._classData, that);
        if (!(md.hasModifier("public") || md.hasModifier("private") || md.hasModifier("protected"))) {
            md.addModifier("public");
        }
        ClassBodyIntermediateVisitor._checkError();
        VariableData[] vds = this.formalParameters2VariableData(that.getParameters(), md);
        if (!ClassBodyIntermediateVisitor._checkError()) {
            md.setParams(vds);
            if (!md.addFinalVars(vds)) {
                ClassBodyIntermediateVisitor._addAndIgnoreError("You cannot have two method parameters with the same name", that);
            }
        }
        this._classData.addMethod(md);
        that.getStatements().visit(new BodyBodyIntermediateVisitor(md, this._file, this._package, this._importedFiles, this._importedPackages, this._classNamesInThisFile, continuations, this._innerClassesToBeParsed));
        this._classData.incrementConstructorCount();
        return this.forConstructorDefOnly(that);
    }

    @Override
    public Void forComplexAnonymousClassInstantiation(ComplexAnonymousClassInstantiation that) {
        this.complexAnonymousClassInstantiationHelper(that, this._classData);
        return null;
    }

    @Override
    public Void forSimpleAnonymousClassInstantiation(SimpleAnonymousClassInstantiation that) {
        this.simpleAnonymousClassInstantiationHelper(that, this._classData);
        return null;
    }

    static /* synthetic */ SymbolData access$000(ClassBodyIntermediateVisitor x0) {
        return x0._classData;
    }

    static /* synthetic */ SymbolData access$002(ClassBodyIntermediateVisitor x0, SymbolData x1) {
        x0._classData = x1;
        return x0._classData;
    }
}

