/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableCollection<E>
extends AbstractCollection<E>
implements SizedIterable<E>,
Composite,
Serializable {
    private final Iterable<? extends E> _iter;
    private final boolean _fixedSize;
    private int _size;

    public IterableCollection(Iterable<? extends E> iter2) {
        this._iter = iter2;
        this._fixedSize = IterUtil.hasFixedSize(iter2);
        this._size = -1;
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._iter) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._iter) + 1;
    }

    @Override
    public boolean isEmpty() {
        if (this._size == -1) {
            return IterUtil.isEmpty(this._iter);
        }
        return this._size == 0;
    }

    @Override
    public int size() {
        if (this._fixedSize) {
            if (this._size == -1) {
                this._size = IterUtil.sizeOf(this._iter);
            }
            return this._size;
        }
        return IterUtil.sizeOf(this._iter);
    }

    @Override
    public int size(int bound) {
        if (this._fixedSize) {
            if (this._size == -1) {
                int result = IterUtil.sizeOf(this._iter, bound);
                if (result < bound) {
                    this._size = result;
                }
                return result;
            }
            return this._size < bound ? this._size : bound;
        }
        return IterUtil.sizeOf(this._iter, bound);
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._iter);
    }

    @Override
    public boolean hasFixedSize() {
        return this._fixedSize;
    }

    @Override
    public boolean isStatic() {
        return this._fixedSize && IterUtil.isStatic(this._iter);
    }

    @Override
    public boolean contains(Object o) {
        return IterUtil.contains(this._iter, o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator<E>(this._iter.iterator());
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this._iter.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IterableCollection)) {
            return false;
        }
        return this._iter.equals(((IterableCollection)o)._iter);
    }

    @Override
    public int hashCode() {
        return IterableCollection.class.hashCode() ^ this._iter.hashCode();
    }
}

