/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractOneToOneRelation;
import edu.rice.cs.plt.collect.EmptySet;
import edu.rice.cs.plt.collect.LambdaMap;
import edu.rice.cs.plt.collect.OneToOneRelation;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.SingletonMap;
import edu.rice.cs.plt.collect.SingletonSet;
import edu.rice.cs.plt.iter.SingletonIterator;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonRelation<T1, T2>
extends AbstractOneToOneRelation<T1, T2>
implements Serializable {
    private final T1 _first;
    private final T2 _second;

    public SingletonRelation(T1 first, T2 second) {
        this._first = first;
        this._second = second;
    }

    public SingletonRelation(Pair<? extends T1, ? extends T2> pair) {
        this._first = pair.first();
        this._second = pair.second();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int size(int bound) {
        return bound < 1 ? bound : 1;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public boolean contains(T1 candidate1, T2 candidate2) {
        return ObjectUtil.equal(candidate1, this._first) && ObjectUtil.equal(candidate2, this._second);
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof Pair) {
            Pair p = (Pair)obj;
            return ObjectUtil.equal(p.first(), this._first) && ObjectUtil.equal(p.second(), this._second);
        }
        return false;
    }

    @Override
    public Iterator<Pair<T1, T2>> iterator() {
        return new SingletonIterator<Pair<T1, T2>>(Pair.make(this._first, this._second));
    }

    @Override
    public LambdaMap<T1, T2> functionMap() {
        return new SingletonMap<T1, T2>(this._first, this._second);
    }

    @Override
    public LambdaMap<T2, T1> injectionMap() {
        return new SingletonMap<T2, T1>(this._second, this._first);
    }

    @Override
    public PredicateSet<T1> firstSet() {
        return new SingletonSet<T1>(this._first);
    }

    @Override
    public PredicateSet<T2> matchFirst(T1 match) {
        if (this._first == null ? match == null : this._first.equals(match)) {
            return new SingletonSet<T2>(this._second);
        }
        return EmptySet.make();
    }

    @Override
    public PredicateSet<T2> secondSet() {
        return new SingletonSet<T2>(this._second);
    }

    @Override
    public PredicateSet<T1> matchSecond(T2 match) {
        if (this._second == null ? match == null : this._second.equals(match)) {
            return new SingletonSet<T1>(this._first);
        }
        return EmptySet.make();
    }

    @Override
    public OneToOneRelation<T2, T1> inverse() {
        return new SingletonRelation<T2, T1>(this._second, this._first);
    }

    public static <T1, T2> SingletonRelation<T1, T2> make(T1 first, T2 second) {
        return new SingletonRelation<T1, T2>(first, second);
    }

    public static <T1, T2> SingletonRelation<T1, T2> make(Pair<? extends T1, ? extends T2> pair) {
        return new SingletonRelation<T1, T2>(pair);
    }
}

