/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.collect.ListenerSet;
import edu.rice.cs.plt.concurrent.TaskController;
import edu.rice.cs.plt.lambda.LazyRunnable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PollingTaskController<R>
extends TaskController<R> {
    private final LazyRunnable _startDaemon = new LazyRunnable(new Runnable(){

        public void run() {
            Thread t = new Thread("PollingTaskController daemon"){

                public void run() {
                    try {
                        PollingTaskController.this.finish();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
    });

    protected PollingTaskController() {
    }

    @Override
    public ListenerSet.Sink finishListeners() {
        this._startDaemon.run();
        return super.finishListeners();
    }

    protected abstract void update();

    protected abstract void finish() throws InterruptedException;

    protected abstract void finish(long var1, TimeUnit var3) throws InterruptedException, TimeoutException;

    @Override
    protected TaskController.RunningState runningState() {
        return new PollingRunningState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PollingCancelingState
    extends TaskController.CancelingState {
        protected PollingCancelingState() {
            super(PollingTaskController.this);
        }

        @Override
        public void start() {
            PollingTaskController.this.update();
            if (PollingTaskController.this.state.get() != this) {
                ((TaskController.State)PollingTaskController.this.state.get()).start();
            }
        }

        @Override
        public TaskController.Status status() {
            PollingTaskController.this.update();
            return PollingTaskController.this.state.get() == this ? TaskController.Status.RUNNING : ((TaskController.State)PollingTaskController.this.state.get()).status();
        }

        @Override
        public boolean cancel(boolean stopRunning) {
            PollingTaskController.this.update();
            return PollingTaskController.this.state.get() == this ? stopRunning : ((TaskController.State)PollingTaskController.this.state.get()).cancel(stopRunning);
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            PollingTaskController.this.finish();
            if (!PollingTaskController.this.isDone()) {
                throw new IllegalStateException("PollingRunner returned without finishing");
            }
            return ((TaskController.State)PollingTaskController.this.state.get()).get();
        }

        @Override
        public R get(long timeout, TimeUnit u) throws InterruptedException, ExecutionException, TimeoutException {
            PollingTaskController.this.finish(timeout, u);
            if (!PollingTaskController.this.isDone()) {
                throw new IllegalStateException("PollingRunner returned without finishing");
            }
            return ((TaskController.State)PollingTaskController.this.state.get()).get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PollingRunningState
    extends TaskController.RunningState {
        protected PollingRunningState() {
            super(PollingTaskController.this);
        }

        @Override
        public TaskController.Status status() {
            PollingTaskController.this.update();
            return PollingTaskController.this.state.get() == this ? TaskController.Status.RUNNING : ((TaskController.State)PollingTaskController.this.state.get()).status();
        }

        @Override
        public void start() {
            PollingTaskController.this.update();
            if (PollingTaskController.this.state.get() != this) {
                ((TaskController.State)PollingTaskController.this.state.get()).start();
            }
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            PollingTaskController.this.finish();
            if (!PollingTaskController.this.isDone()) {
                throw new IllegalStateException("PollingTaskController returned without finishing");
            }
            return ((TaskController.State)PollingTaskController.this.state.get()).get();
        }

        @Override
        public R get(long timeout, TimeUnit u) throws InterruptedException, ExecutionException, TimeoutException {
            PollingTaskController.this.finish(timeout, u);
            if (!PollingTaskController.this.isDone()) {
                throw new IllegalStateException("PollingTaskController returned without finishing");
            }
            return ((TaskController.State)PollingTaskController.this.state.get()).get();
        }

        @Override
        public boolean cancel(boolean stopRunning) {
            PollingTaskController.this.update();
            if (PollingTaskController.this.state.get() == this) {
                if (stopRunning) {
                    if (PollingTaskController.this.state.compareAndSet(this, new PollingCancelingState())) {
                        PollingTaskController.this.doStop();
                        return true;
                    }
                    return ((TaskController.State)PollingTaskController.this.state.get()).cancel(stopRunning);
                }
                return false;
            }
            return ((TaskController.State)PollingTaskController.this.state.get()).cancel(stopRunning);
        }
    }
}

