/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.ComposedIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.SingletonIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedIterable<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
OptimizedLastIterable<T>,
Composite,
Serializable {
    private final Iterable<? extends T> _i1;
    private final int _i1Size;
    private final Iterable<? extends T> _i2;
    private final int _i2Size;
    private final boolean _isStatic;

    public ComposedIterable(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        this._i1 = i1;
        this._i2 = i2;
        this._i1Size = IterUtil.hasFixedSize(this._i1) ? IterUtil.sizeOf(this._i1) : -1;
        this._i2Size = IterUtil.hasFixedSize(this._i2) ? IterUtil.sizeOf(this._i2) : -1;
        this._isStatic = IterUtil.isStatic(this._i1) && IterUtil.isStatic(this._i2);
    }

    public ComposedIterable(T v1, Iterable<? extends T> i2) {
        this((Iterable<Iterable<? extends T>>)new SingletonIterable<T>(v1), i2);
    }

    public ComposedIterable(Iterable<? extends T> i1, T v2) {
        this(i1, new SingletonIterable<T>(v2));
    }

    @Override
    public ComposedIterator<T> iterator() {
        return new ComposedIterator<T>(this._i1.iterator(), this._i2.iterator());
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._i1, this._i2) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._i1, this._i2) + 1;
    }

    @Override
    public boolean isEmpty() {
        return (this._i1Size < 0 ? IterUtil.isEmpty(this._i1) : this._i1Size == 0) && (this._i2Size < 0 ? IterUtil.isEmpty(this._i2) : this._i2Size == 0);
    }

    @Override
    public int size() {
        int result = (this._i1Size < 0 ? IterUtil.sizeOf(this._i1) : this._i1Size) + (this._i2Size < 0 ? IterUtil.sizeOf(this._i2) : this._i2Size);
        if (result < 0) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    @Override
    public int size(int bound) {
        int size1 = this._i1Size < 0 ? IterUtil.sizeOf(this._i1, bound) : (bound < this._i1Size ? bound : this._i1Size);
        int bound2 = bound - size1;
        int size2 = this._i2Size < 0 ? IterUtil.sizeOf(this._i2, bound2) : (bound2 < this._i2Size ? bound2 : this._i2Size);
        return size1 + size2;
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._i1) || IterUtil.isInfinite(this._i2);
    }

    @Override
    public boolean hasFixedSize() {
        return this._i1Size >= 0 && this._i2Size >= 0;
    }

    @Override
    public boolean isStatic() {
        return this._isStatic;
    }

    @Override
    public T last() {
        Iterable<? extends T> lastIterable = IterUtil.isEmpty(this._i2) ? this._i1 : this._i2;
        while (lastIterable instanceof ComposedIterable) {
            ComposedIterable cast = (ComposedIterable)lastIterable;
            if (IterUtil.isEmpty(cast._i2)) {
                lastIterable = cast._i1;
                continue;
            }
            lastIterable = cast._i2;
        }
        return IterUtil.last(lastIterable);
    }

    public static <T> ComposedIterable<T> make(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        return new ComposedIterable<Iterable<? extends T>>(i1, i2);
    }

    public static <T> ComposedIterable<T> make(T v1, Iterable<? extends T> i2) {
        return new ComposedIterable<T>(v1, i2);
    }

    public static <T> ComposedIterable<T> make(Iterable<? extends T> i1, T v2) {
        return new ComposedIterable<T>(i1, v2);
    }
}

