/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagonalCartesianIterator<T1, T2, R>
extends ReadOnlyIterator<R>
implements Composite {
    private final Lambda2<? super T1, ? super T2, ? extends R> _combiner;
    private final Iterator<? extends T1> _left;
    private final Iterator<? extends T2> _right;
    private LinkedList<T1> _leftCache;
    private Iterator<T1> _leftCacheIter;
    private LinkedList<T2> _rightCache;
    private Iterator<T2> _rightCacheIter;

    public DiagonalCartesianIterator(Iterator<? extends T1> left, Iterator<? extends T2> right, Lambda2<? super T1, ? super T2, ? extends R> combiner) {
        this._combiner = combiner;
        this._left = left;
        this._right = right;
        this._leftCache = new LinkedList();
        this._rightCache = new LinkedList();
        this._leftCacheIter = this._leftCache.iterator();
        this._rightCacheIter = this._rightCache.iterator();
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._left, this._right) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._left, this._right) + 1;
    }

    @Override
    public boolean hasNext() {
        if (this._left.hasNext()) {
            return this._right.hasNext() || !this._rightCache.isEmpty();
        }
        if (this._right.hasNext()) {
            return !this._leftCache.isEmpty();
        }
        return this._leftCacheIter.hasNext() && this._rightCacheIter.hasNext() || this._leftCache.size() > 1 && this._rightCache.size() > 1;
    }

    @Override
    public R next() {
        if (!this._leftCacheIter.hasNext() || !this._rightCacheIter.hasNext()) {
            if (this._left.hasNext()) {
                this._leftCache.addLast(this._left.next());
            } else if (!this._rightCache.isEmpty()) {
                this._rightCache.removeLast();
            }
            if (this._right.hasNext()) {
                this._rightCache.addFirst(this._right.next());
            } else if (!this._leftCache.isEmpty()) {
                this._leftCache.removeFirst();
            }
            this._leftCacheIter = this._leftCache.iterator();
            this._rightCacheIter = this._rightCache.iterator();
        }
        return this._combiner.value(this._leftCacheIter.next(), this._rightCacheIter.next());
    }

    public static <T1, T2, R> DiagonalCartesianIterator<T1, T2, R> make(Iterator<? extends T1> left, Iterator<? extends T2> right, Lambda2<? super T1, ? super T2, ? extends R> combiner) {
        return new DiagonalCartesianIterator<T1, T2, R>(left, right, combiner);
    }
}

