/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.ReadOnlyIterator;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.OptionUnwrapException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoDuplicatesIterator<T>
extends ReadOnlyIterator<T>
implements Composite {
    private final Iterator<? extends T> _i;
    private final Set<T> _seen;
    private Option<T> _lookahead;

    public NoDuplicatesIterator(Iterator<? extends T> i) {
        this._i = i;
        this._seen = new HashSet<T>();
        this.advanceLookahead();
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._i) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._i) + 1;
    }

    @Override
    public boolean hasNext() {
        return this._lookahead.isSome();
    }

    @Override
    public T next() {
        try {
            T result = this._lookahead.unwrap();
            this.advanceLookahead();
            return result;
        }
        catch (OptionUnwrapException e) {
            throw new NoSuchElementException();
        }
    }

    private void advanceLookahead() {
        this._lookahead = Option.none();
        while (this._i.hasNext() && this._lookahead.isNone()) {
            T next = this._i.next();
            if (this._seen.contains(next)) continue;
            this._lookahead = Option.some(next);
            this._seen.add(next);
        }
    }

    public static <T> NoDuplicatesIterator<T> make(Iterator<? extends T> i) {
        return new NoDuplicatesIterator<T>(i);
    }
}

