/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.recur;

import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.IdentityPair;
import edu.rice.cs.plt.tuple.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecomputedRecursionStack2<T1, T2, R> {
    private final Lambda2<? super T1, ? super T2, ? extends Pair<T1, T2>> _pairFactory;
    private final Map<Pair<T1, T2>, Lambda2<? super T1, ? super T2, ? extends R>> _previous;
    private final LinkedList<Pair<T1, T2>> _stack;

    public PrecomputedRecursionStack2() {
        this(IdentityPair.factory());
    }

    public PrecomputedRecursionStack2(Lambda2<? super T1, ? super T2, ? extends Pair<T1, T2>> pairFactory) {
        this._pairFactory = pairFactory;
        this._previous = new HashMap<Pair<T1, T2>, Lambda2<? super T1, ? super T2, ? extends R>>();
        this._stack = new LinkedList();
    }

    public boolean contains(T1 arg1, T2 arg2) {
        return this._previous.containsKey(this._pairFactory.value(arg1, arg2));
    }

    public R get(T1 arg1, T2 arg2) {
        Lambda2<T1, T2, R> result = this._previous.get(this._pairFactory.value(arg1, arg2));
        if (result == null) {
            throw new IllegalArgumentException("Values are not on the stack");
        }
        return result.value(arg1, arg2);
    }

    public void push(T1 arg1, T2 arg2, R value) {
        this.push(arg1, arg2, (Lambda2<? super T1, ? super T2, ? extends R>)LambdaUtil.valueLambda(value));
    }

    public void push(T1 arg1, T2 arg2, Thunk<? extends R> value) {
        this.push(arg1, arg2, (Lambda2<? super T1, ? super T2, ? extends R>)LambdaUtil.promote(value));
    }

    public void push(T1 arg1, T2 arg2, Lambda2<? super T1, ? super T2, ? extends R> value) {
        Pair<T1, T2> wrapped = this._pairFactory.value(arg1, arg2);
        if (this._previous.containsKey(wrapped)) {
            throw new IllegalArgumentException("The given arguments are already on the stack");
        }
        this._stack.addLast(wrapped);
        this._previous.put(wrapped, value);
    }

    public void pop(T1 arg1, T2 arg2) {
        Pair<T1, T2> wrapped = this._pairFactory.value(arg1, arg2);
        if (this._stack.isEmpty() || !this._stack.getLast().equals(wrapped)) {
            throw new IllegalArgumentException("the given arguments are not on top of the stack");
        }
        this._stack.removeLast();
        this._previous.remove(wrapped);
    }

    public int size() {
        return this._stack.size();
    }

    public boolean isEmpty() {
        return this._stack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, R precomputed, T1 arg1, T2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return this.get(arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, Thunk<? extends R> precomputed, T1 arg1, T2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return this.get(arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, Lambda2<? super T1, ? super T2, ? extends R> precomputed, T1 arg1, T2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return this.get(arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda2<? super T1, ? super T2, ? extends R> lambda, R precomputed, T1 arg1, T2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2, precomputed);
            try {
                R r = lambda.value(arg1, arg2);
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return this.get(arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda2<? super T1, ? super T2, ? extends R> lambda, Thunk<? extends R> precomputed, T1 arg1, T2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2, precomputed);
            try {
                R r = lambda.value(arg1, arg2);
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return this.get(arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda2<? super T1, ? super T2, ? extends R> lambda, Lambda2<? super T1, ? super T2, ? extends R> precomputed, T1 arg1, T2 arg2) {
        if (!this.contains(arg1, arg2)) {
            this.push(arg1, arg2, precomputed);
            try {
                R r = lambda.value(arg1, arg2);
                return r;
            }
            finally {
                this.pop(arg1, arg2);
            }
        }
        return this.get(arg1, arg2);
    }

    public static <T1, T2, R> PrecomputedRecursionStack2<T1, T2, R> make() {
        return new PrecomputedRecursionStack2<T1, T2, R>();
    }

    public static <T1, T2, R> PrecomputedRecursionStack2<T1, T2, R> make(Lambda2<? super T1, ? super T2, ? extends Pair<T1, T2>> pairFactory) {
        return new PrecomputedRecursionStack2<T1, T2, R>(pairFactory);
    }
}

