/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.reflect;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVersion {
    UNRECOGNIZED{

        public String versionString() {
            return "?";
        }
    }
    ,
    JAVA_1_1{

        public String versionString() {
            return "1.1";
        }
    }
    ,
    JAVA_1_2{

        public String versionString() {
            return "1.2";
        }
    }
    ,
    JAVA_1_3{

        public String versionString() {
            return "1.3";
        }
    }
    ,
    JAVA_1_4{

        public String versionString() {
            return "1.4";
        }
    }
    ,
    JAVA_5{

        public String versionString() {
            return "5";
        }
    }
    ,
    JAVA_6{

        public String versionString() {
            return "6";
        }
    }
    ,
    JAVA_7{

        public String versionString() {
            return "7";
        }
    }
    ,
    FUTURE{

        public String versionString() {
            return ">7";
        }
    };

    public static final JavaVersion CURRENT;
    public static final FullVersion CURRENT_FULL;

    public boolean supports(JavaVersion v) {
        return this.compareTo(v) >= 0;
    }

    public abstract String versionString();

    public String toString() {
        return "Java " + this.versionString();
    }

    public FullVersion fullVersion() {
        return new FullVersion(this, 0, 0, ReleaseType.STABLE, null, VendorType.UNKNOWN, "");
    }

    public static JavaVersion parseClassVersion(String text) {
        int dot = text.indexOf(46);
        if (dot == -1) {
            return UNRECOGNIZED;
        }
        try {
            int major = Integer.parseInt(text.substring(0, dot));
            int minor = Integer.parseInt(text.substring(dot + 1));
            switch (major) {
                case 45: {
                    if (minor >= 3) {
                        return JAVA_1_1;
                    }
                    return UNRECOGNIZED;
                }
                case 46: {
                    return JAVA_1_2;
                }
                case 47: {
                    return JAVA_1_3;
                }
                case 48: {
                    return JAVA_1_4;
                }
                case 49: {
                    return JAVA_5;
                }
                case 50: {
                    return JAVA_6;
                }
                case 51: {
                    return JAVA_7;
                }
            }
            return major > 51 ? FUTURE : UNRECOGNIZED;
        }
        catch (NumberFormatException e) {
            return UNRECOGNIZED;
        }
    }

    public static FullVersion parseFullVersion(String java_version, String java_runtime_name, String java_vm_vendor) {
        String typeString;
        String number;
        int dash;
        VendorType vendor = VendorType.UNKNOWN;
        String vendorString = null;
        if (java_runtime_name.toLowerCase().contains("mint")) {
            vendor = VendorType.MINT;
            vendorString = "Mint";
        }
        if (java_runtime_name.toLowerCase().contains("openjdk")) {
            vendor = VendorType.OPENJDK;
            vendorString = "OpenJDK";
        } else if (java_vm_vendor.toLowerCase().contains("apple")) {
            vendor = VendorType.APPLE;
            vendorString = "Apple";
        } else if (java_vm_vendor.toLowerCase().contains("sun") || java_vm_vendor.toLowerCase().contains("oracle")) {
            vendor = VendorType.SUN;
            vendorString = "Sun";
        }
        if (!java_version.startsWith("1.") && java_version.replaceAll("[^\\.]", "").length() == 1) {
            java_version = "1." + java_version;
        }
        if ((dash = java_version.indexOf(45)) == -1) {
            number = java_version;
            typeString = null;
        } else {
            number = java_version.substring(0, dash);
            typeString = java_version.substring(dash + 1);
        }
        int dot1 = number.indexOf(46);
        if (dot1 == -1) {
            return new FullVersion(UNRECOGNIZED, 0, 0, ReleaseType.STABLE, null, vendor, vendorString);
        }
        int dot2 = number.indexOf(46, dot1 + 1);
        if (dot2 == -1) {
            return new FullVersion(UNRECOGNIZED, 0, 0, ReleaseType.STABLE, null, vendor, vendorString);
        }
        int underscore = number.indexOf(95, dot2 + 1);
        if (underscore == -1) {
            underscore = number.indexOf(46, dot2 + 1);
        }
        if (underscore == -1) {
            underscore = number.length();
        }
        try {
            int update;
            int major = Integer.parseInt(number.substring(0, dot1));
            int feature = Integer.parseInt(number.substring(dot1 + 1, dot2));
            int maintenance = Integer.parseInt(number.substring(dot2 + 1, underscore));
            int n = update = underscore >= number.length() ? 0 : Integer.parseInt(number.substring(underscore + 1));
            ReleaseType type = typeString == null ? ReleaseType.STABLE : (typeString.startsWith("ea") ? ReleaseType.EARLY_ACCESS : (typeString.startsWith("beta") ? ReleaseType.BETA : (typeString.startsWith("rc") ? ReleaseType.RELEASE_CANDIDATE : ReleaseType.UNRECOGNIZED)));
            JavaVersion version = UNRECOGNIZED;
            if (major == 1) {
                switch (feature) {
                    case 1: {
                        version = JAVA_1_1;
                        break;
                    }
                    case 2: {
                        version = JAVA_1_2;
                        break;
                    }
                    case 3: {
                        version = JAVA_1_3;
                        break;
                    }
                    case 4: {
                        version = JAVA_1_4;
                        break;
                    }
                    case 5: {
                        version = JAVA_5;
                        break;
                    }
                    case 6: {
                        version = JAVA_6;
                        break;
                    }
                    case 7: {
                        version = JAVA_7;
                        break;
                    }
                    default: {
                        if (feature <= 7) break;
                        version = FUTURE;
                    }
                }
            }
            return new FullVersion(version, maintenance, update, type, typeString, vendor, vendorString);
        }
        catch (NumberFormatException e) {
            return new FullVersion(UNRECOGNIZED, 0, 0, ReleaseType.STABLE, null, vendor, vendorString);
        }
    }

    public static FullVersion parseFullVersion(String text) {
        return JavaVersion.parseFullVersion(text, "", "");
    }

    static {
        CURRENT = JavaVersion.parseClassVersion(System.getProperty("java.class.version", ""));
        CURRENT_FULL = JavaVersion.parseFullVersion(System.getProperty("java.version", ""), System.getProperty("java.runtime.name", ""), System.getProperty("java.vm.vendor", ""));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VendorType {
        UNKNOWN,
        MINT,
        OPENJDK,
        APPLE,
        SUN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReleaseType {
        UNRECOGNIZED,
        EARLY_ACCESS,
        BETA,
        RELEASE_CANDIDATE,
        STABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FullVersion
    implements Comparable<FullVersion>,
    Serializable {
        private JavaVersion _majorVersion;
        private int _maintenance;
        private int _update;
        private ReleaseType _type;
        private String _typeString;
        private VendorType _vendor;
        private String _vendorString;

        private FullVersion(JavaVersion majorVersion, int maintenance, int update, ReleaseType type, String typeString, VendorType vendor, String vendorString) {
            this._majorVersion = majorVersion;
            this._maintenance = maintenance;
            this._update = update;
            this._type = type;
            this._typeString = typeString;
            this._vendor = vendor;
            this._vendorString = vendorString;
        }

        public JavaVersion majorVersion() {
            return this._majorVersion;
        }

        public FullVersion onlyMajorVersionAndVendor() {
            return new FullVersion(this._majorVersion, 0, 0, ReleaseType.STABLE, null, this._vendor, this._vendorString);
        }

        public int maintenance() {
            return this._maintenance;
        }

        public int update() {
            return this._update;
        }

        public ReleaseType release() {
            return this._type;
        }

        public VendorType vendor() {
            return this._vendor;
        }

        public boolean supports(JavaVersion v) {
            return this._majorVersion.supports(v);
        }

        @Override
        public int compareTo(FullVersion v) {
            if (this._vendor == VendorType.MINT && v._vendor != VendorType.MINT) {
                return -1;
            }
            if (v._vendor == VendorType.MINT && this._vendor != VendorType.MINT) {
                return 1;
            }
            int result = this._majorVersion.compareTo(v._majorVersion);
            if (result == 0 && (result = this._maintenance - v._maintenance) == 0 && (result = this._update - v._update) == 0 && (result = this._type.compareTo(v._type)) == 0 && (result = this._vendor.compareTo(v._vendor)) == 0 && !this._type.equals((Object)ReleaseType.STABLE)) {
                result = this._typeString.compareTo(v._typeString);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FullVersion)) {
                return false;
            }
            FullVersion v = (FullVersion)o;
            return this._majorVersion.equals((Object)v._majorVersion) && this._maintenance == v._maintenance && this._update == v._update && this._type.equals((Object)v._type) && this._vendor.equals((Object)v._vendor) && (this._type.equals((Object)ReleaseType.STABLE) || this._typeString.equals(v._typeString));
        }

        public int hashCode() {
            int stringHash = this._typeString == null ? 0 : this._typeString.hashCode();
            return this._majorVersion.hashCode() ^ this._maintenance << 1 ^ this._update << 2 ^ this._type.hashCode() << 3 ^ this._vendor.hashCode() << 4 ^ stringHash;
        }

        private String stringSuffix() {
            StringBuilder result = new StringBuilder();
            result.append("." + this._maintenance);
            if (this._update != 0) {
                result.append("_" + this._update);
            }
            if (!this._type.equals((Object)ReleaseType.STABLE)) {
                result.append('-').append(this._typeString);
            }
            if (!(this._vendor.equals((Object)VendorType.SUN) || this._vendor.equals((Object)VendorType.APPLE) || this._vendor.equals((Object)VendorType.UNKNOWN))) {
                result.append('-').append(this._vendorString);
            }
            return result.toString();
        }

        public String versionString() {
            return this._majorVersion.versionString() + this.stringSuffix();
        }

        public String toString() {
            return (Object)((Object)this._majorVersion) + this.stringSuffix();
        }
    }
}

