/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLInfoPanel
extends IzPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 3257008769514025270L;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private JLabel infoLabel;
    private JEditorPane textArea;

    public HTMLInfoPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        this.setLayout(this.layout);
        this.infoLabel = LabelFactory.create(parent.langpack.getString("InfoPanel.info"), parent.icons.getImageIcon("edit"), 11);
        parent.buildConstraints(this.gbConstraints, 0, 0, 1, 1, 1.0, 0.0);
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.infoLabel, this.gbConstraints);
        this.add(this.infoLabel);
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadInfo());
            parent.buildConstraints(this.gbConstraints, 0, 1, 1, 1, 1.0, 1.0);
            this.gbConstraints.anchor = 10;
            this.gbConstraints.fill = 1;
            this.layout.addLayoutComponent(scroller, this.gbConstraints);
            this.add(scroller);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private URL loadInfo() {
        String resNamePrifix = "HTMLInfoPanel.info";
        try {
            return ResourceManager.getInstance().getURL(resNamePrifix);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean isValidated() {
        return true;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.textArea.setPage(e.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

