/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.ShellLink;
import com.izforge.izpack.util.os.Shortcut;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Win_Shortcut
extends Shortcut {
    private ShellLink shortcut;
    private static String myClass = Win_Shortcut.class.getName() + ": ";
    private static final String CLASS = "Class: ";
    private static final boolean SUPPORTED = true;

    public void initialize(int type, String name) throws Exception {
        Debug.log(CLASS + myClass + ".initialize() '" + Integer.toString(type) + "', '" + name + "'");
        switch (type) {
            case 1: {
                this.shortcut = new ShellLink(2, name);
                break;
            }
            case 2: {
                this.shortcut = new ShellLink(3, name);
                break;
            }
            case 3: {
                this.shortcut = new ShellLink(1, name);
                break;
            }
            case 4: {
                this.shortcut = new ShellLink(4, name);
                break;
            }
            default: {
                this.shortcut = new ShellLink(2, name);
            }
        }
    }

    public String getBasePath() throws Exception {
        String result = this.shortcut.getLinkPath(this.shortcut.getUserType());
        Debug.log(CLASS + myClass + ".getBasePath() '" + result + "'");
        return result;
    }

    public Vector getProgramGroups(int userType) {
        int logentry = 0;
        Debug.log(CLASS + myClass + ".getProgramGroups()-" + logentry++ + " '" + Integer.toString(userType) + "'");
        int type = 0;
        type = userType == 2 ? 1 : 0;
        String linkPath = this.shortcut.getLinkPath(type);
        Debug.log(CLASS + myClass + ".getProgramGroups()-" + logentry++ + " '" + linkPath + "'");
        if (linkPath == null) {
            return new Vector();
        }
        File path = new File(linkPath);
        File[] file = path.listFiles();
        Vector<String> groups = new Vector<String>();
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                File aFile = file[i];
                String aFilename = aFile.getName();
                if (aFile.isDirectory()) {
                    Debug.log(CLASS + myClass + ".getProgramGroups()-" + logentry++ + " '" + aFilename + "'");
                    groups.add(aFilename);
                    continue;
                }
                Debug.log(CLASS + myClass + ".getProgramGroups()-" + logentry++ + " Skip (NoDirectory): '" + aFilename + "'");
            }
        }
        return groups;
    }

    public String getFileName() {
        String aFilename = this.shortcut.getFileName();
        Debug.log(CLASS + myClass + ".getFileName() '" + aFilename + "'");
        return aFilename;
    }

    public String getDirectoryCreated() {
        String directoryCreated = this.shortcut.getDirectoryCreated();
        Debug.log(CLASS + myClass + ".getDirectoryCreated() '" + directoryCreated + "'");
        return directoryCreated;
    }

    public boolean multipleUsers() {
        boolean result = false;
        String allUsers = this.shortcut.getallUsersLinkPath();
        Debug.log(CLASS + myClass + ".multipleUsers()-1 '" + allUsers + "'");
        String currentUsers = this.shortcut.getcurrentUserLinkPath();
        Debug.log(CLASS + myClass + ".multipleUsers()-2 '" + currentUsers + "'");
        result = allUsers == null || currentUsers == null ? false : allUsers.length() > 0 && currentUsers.length() > 0;
        Debug.log(CLASS + myClass + ".multipleUsers()-3 '" + result + "'");
        return result;
    }

    public boolean supported() {
        Debug.log(CLASS + myClass + ".supported() '" + true + "'");
        return true;
    }

    public void setArguments(String arguments) {
        Debug.log(CLASS + myClass + ".setArguments() '" + arguments + "'");
        this.shortcut.setArguments(arguments);
    }

    public void setDescription(String description) {
        Debug.log(CLASS + myClass + ".setDescription() '" + description + "'");
        this.shortcut.setDescription(description);
    }

    public void setIconLocation(String path, int index) {
        Debug.log(CLASS + myClass + ".setIconLocation() '" + path + "', '" + Integer.toString(index) + "'");
        this.shortcut.setIconLocation(path, index);
    }

    public String getIconLocation() {
        String result = this.shortcut.getIconLocation();
        Debug.log(CLASS + myClass + ".getIconLocation() '" + result + "'");
        return result;
    }

    public void setProgramGroup(String groupName) {
        Debug.log(CLASS + myClass + ".setProgramGroup() '" + groupName + "'");
        this.shortcut.setProgramGroup(groupName);
    }

    public void setShowCommand(int show) throws IllegalArgumentException {
        Debug.log(CLASS + myClass + ".setShowCommand() '" + Integer.toString(show) + "'");
        switch (show) {
            case 0: {
                this.shortcut.setShowCommand(7);
                break;
            }
            case 1: {
                this.shortcut.setShowCommand(1);
                break;
            }
            case 2: {
                this.shortcut.setShowCommand(7);
                break;
            }
            case 3: {
                this.shortcut.setShowCommand(3);
                break;
            }
            default: {
                throw new IllegalArgumentException(show + "is not recognized as a show command");
            }
        }
    }

    public int getShowCommand() {
        int showCommand = this.shortcut.getShowCommand();
        Debug.log(CLASS + myClass + ".getShowCommand() '" + Integer.toString(showCommand) + "'");
        switch (showCommand) {
            case 1: {
                showCommand = 1;
                break;
            }
            case 2: 
            case 7: {
                showCommand = 2;
                break;
            }
            case 3: {
                showCommand = 3;
                break;
            }
        }
        return showCommand;
    }

    public void setTargetPath(String path) {
        Debug.log(CLASS + myClass + ".setTargetPath() '" + path + "'");
        this.shortcut.setTargetPath(path);
    }

    public void setWorkingDirectory(String dir) {
        Debug.log(CLASS + myClass + ".setWorkingDirectory() '" + dir + "'");
        this.shortcut.setWorkingDirectory(dir);
    }

    public String getWorkingDirectory() {
        String result = this.shortcut.getWorkingDirectory();
        Debug.log(CLASS + myClass + ".getWorkingDirectory() '" + result + "'");
        return result;
    }

    public void setLinkName(String name) {
        Debug.log(CLASS + myClass + ".setLinkName() '" + name + "'");
        this.shortcut.setLinkName(name);
    }

    public int getLinkType() {
        int typ = this.shortcut.getLinkType();
        Debug.log(CLASS + myClass + ".getLinkType() '" + typ + "'");
        switch (typ) {
            case 1: {
                typ = 3;
                break;
            }
            case 2: {
                typ = 1;
                break;
            }
            case 3: {
                typ = 2;
                break;
            }
            case 4: {
                typ = 4;
                break;
            }
        }
        return typ;
    }

    public void setLinkType(int type) throws IllegalArgumentException, UnsupportedEncodingException {
        Debug.log(CLASS + myClass + ".setLinkType() '" + type + "'");
        switch (type) {
            case 3: {
                this.shortcut.setLinkType(1);
                break;
            }
            case 1: {
                this.shortcut.setLinkType(2);
                break;
            }
            case 2: {
                this.shortcut.setLinkType(3);
                break;
            }
            case 4: {
                this.shortcut.setLinkType(4);
                break;
            }
            default: {
                throw new IllegalArgumentException(type + "is not recognized as a valid link type");
            }
        }
    }

    public int getUserType() {
        int utype = this.shortcut.getUserType();
        Debug.log(CLASS + myClass + ".getUserType() '" + utype + "'");
        switch (utype) {
            case 1: {
                utype = 2;
                break;
            }
            case 0: {
                utype = 1;
            }
        }
        return utype;
    }

    public void setUserType(int type) {
        Debug.log(CLASS + myClass + ".setUserType() '" + type + "'");
        if (type == 1) {
            if (this.shortcut.getcurrentUserLinkPath().length() > 0) {
                this.shortcut.setUserType(0);
            }
        } else if (type == 2 && this.shortcut.getallUsersLinkPath().length() > 0) {
            this.shortcut.setUserType(1);
        }
    }

    public void save() throws Exception {
        this.shortcut.save();
    }

    public int getHotkey() {
        int result = this.shortcut.getHotkey();
        Debug.log(CLASS + myClass + ".getHotkey() '" + result + "'");
        return result;
    }

    public void setHotkey(int hotkey) {
        Debug.log(CLASS + myClass + ".setHotkey() '" + hotkey + "'");
        this.shortcut.setHotkey(hotkey);
    }

    public String getProgramsFolder(int current_user) {
        String result = null;
        try {
            result = new String(this.shortcut.getLinkPath(current_user).getBytes(StringTool.getPlatformEncoding()), StringTool.getPlatformEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Debug.log(CLASS + myClass + ".getProgramsFolder() '" + current_user + "', '" + result + "'");
        return result;
    }
}

