/*
 * Decompiled with CFR 0.152.
 */
package org.exist.izpack;

import com.izforge.izpack.installer.AutomatedInstaller;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;

public class CommandLineInstaller {
    private static final int HELP_OPT = 104;
    private static final int PATH_OPT = 112;

    protected void execute(String[] args) throws Exception {
        if (args.length == 0 && !System.getProperty("os.name").startsWith("OpenServer")) {
            System.out.println("\neXist Installation");
            System.out.println("------------------------");
            System.out.println("Using GUI mode ...");
            System.out.println("On a headless system, add parameter -p install-path");
            System.out.println("to install without GUI. If you are running JDK 1.4, you may");
            System.out.println("also try to pass: -Djava.awt.headless=true -p install-path");
            System.out.println("as arguments to the Java executable.");
            Class.forName("com.izforge.izpack.installer.GUIInstaller").newInstance();
        } else {
            String installPath = System.getProperty("user.home") + "/eXist";
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    CommandLineInstaller.printHelp();
                    return;
                }
                if (!args[i].equals("-p")) continue;
                if (++i == args.length) {
                    System.out.println("Option -p requires an argument: the path to the directory where you want to have eXist installed.");
                    return;
                }
                installPath = args[i];
            }
            System.out.println("Installing into directory: " + installPath);
            String filename = File.createTempFile("inst", ".xml").getAbsolutePath();
            FileWriter w = new FileWriter(filename);
            w.write("<AutomatedInstallation langpack=\"eng\">\n");
            w.write("<com.izforge.izpack.panels.HelloPanel/>\n    <com.izforge.izpack.panels.PacksPanel>\n        <selected>\n            <pack index=\"0\"/>\n            <pack index=\"1\"/>\n            <pack index=\"2\"/>\n        </selected>\n    </com.izforge.izpack.panels.PacksPanel>\n");
            w.write("<com.izforge.izpack.panels.TargetPanel>\n        <installpath>" + installPath + "</installpath>\n" + "    </com.izforge.izpack.panels.TargetPanel>\n");
            w.write("<com.izforge.izpack.panels.InstallPanel/>\n");
            w.write("<com.izforge.izpack.panels.FinishPanel/>\n");
            w.write("</AutomatedInstallation>");
            ((Writer)w).close();
            new AutomatedInstaller(filename);
            new File(filename).delete();
        }
    }

    private static void printHelp() {
        System.out.println("Usage: java " + CommandLineInstaller.class.getName() + " [options]");
        System.out.println("Options:");
        System.out.println("    -p install-path");
        System.out.println("        Install eXist with default options and no GUI into directory 'install-path'");
        System.out.println("    -h");
        System.out.println("        Print this help message and exit");
    }

    public static void main(String[] args) {
        CommandLineInstaller inst = new CommandLineInstaller();
        try {
            inst.execute(args);
        }
        catch (Exception e) {
            System.err.println("Installer exited with an error: " + e.getMessage());
        }
    }
}

