/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.core.launching;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.core.launching.CoverageLauncher;
import com.mountainminds.eclemma.core.launching.ICoverageLaunchInfo;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import com.mountainminds.eclemma.internal.core.EclipseVersion;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class EclipseLauncher
extends CoverageLauncher {
    protected static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    protected static final String PRE320VMARGS = "vmargs";
    protected static final String VMARGS = IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS;
    public static final String BOOTPATHARG = "-Xbootclasspath/a:";

    protected String getVMArgsKey() {
        boolean is320 = EclipseVersion.isGreaterOrEqualTo(EclipseVersion.V320);
        return is320 ? VMARGS : PRE320VMARGS;
    }

    protected void addVMArgument(ILaunchConfigurationWorkingCopy workingcopy, String arg) throws CoreException {
        String vmargskey = this.getVMArgsKey();
        StringBuffer sb = new StringBuffer(workingcopy.getAttribute(vmargskey, ""));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        if (arg.indexOf(32) == -1) {
            sb.append(arg);
        } else {
            sb.append('\"').append(arg).append('\"');
        }
        workingcopy.setAttribute(vmargskey, sb.toString());
    }

    protected boolean hasInplaceInstrumentation(ILaunchConfiguration configuration) {
        return true;
    }

    protected void modifyConfiguration(ILaunchConfigurationWorkingCopy workingcopy, ICoverageLaunchInfo info) throws CoreException {
        StringBuffer sb = new StringBuffer(BOOTPATHARG);
        sb.append(info.getPropertiesJARFile());
        sb.append(File.pathSeparatorChar).append(CoverageTools.getEmmaJar().toOSString());
        this.addVMArgument(workingcopy, sb.toString());
    }

    public IClassFiles[] getClassFiles(ILaunchConfiguration configuration, boolean includebinaries) throws CoreException {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaProject[] projects = model.getJavaProjects();
        ArrayList<IClassFiles> l = new ArrayList<IClassFiles>();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getProject().hasNature(PLUGIN_NATURE)) {
                IClassFiles[] cf = EclEmmaCorePlugin.getClassFiles(projects[i]);
                int j = 0;
                while (j < cf.length) {
                    if (!cf[j].isBinary()) {
                        l.add(cf[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return l.toArray(new IClassFiles[0]);
    }
}

