/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.coverageview;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionManager;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class SelectSessionAction
extends Action
implements IMenuCreator {
    private Menu menu;

    SelectSessionAction() {
        this.setText(UIMessages.CoverageViewSelectSessionAction_label);
        this.setToolTipText(UIMessages.CoverageViewSelectSessionAction_looltip);
        this.setImageDescriptor(EclEmmaUIPlugin.getImageDescriptor("icons/full/elcl16/session.gif"));
        this.setDisabledImageDescriptor(EclEmmaUIPlugin.getImageDescriptor("icons/full/dlcl16/session.gif"));
        this.setMenuCreator(this);
        this.setEnabled(false);
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        WorkbenchLabelProvider labelprovider = new WorkbenchLabelProvider();
        final ISessionManager manager = CoverageTools.getSessionManager();
        ICoverageSession[] sessions = manager.getSessions();
        ICoverageSession active = manager.getActiveSession();
        int i = 0;
        while (i < sessions.length) {
            final ICoverageSession session = sessions[i];
            MenuItem item = new MenuItem(this.menu, 16);
            Object[] labelparams = new Object[]{new Integer(i + 1), labelprovider.getText((Object)session)};
            item.setText(NLS.bind((String)UIMessages.CoverageViewSelectSessionActionEntry_label, (Object[])labelparams));
            item.setImage(labelprovider.getImage((Object)session));
            item.setSelection(session == active);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    manager.activateSession(session);
                }
            });
            ++i;
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void dispose() {
    }
}

