/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.decorators;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.analysis.ICounter;
import com.mountainminds.eclemma.core.analysis.IJavaCoverageListener;
import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.IWorkbench;

public class CoverageDecorator
implements ILightweightLabelDecorator {
    private static final Format SUFFIX_FORMAT = new DecimalFormat(UIMessages.CoverageDecoratorSuffix_label);
    private List listeners = new ArrayList();
    private IJavaCoverageListener coverageListener = null;

    public void decorate(Object element, IDecoration decoration) {
        IJavaElementCoverage coverage = CoverageTools.getCoverageInfo((Object)element);
        if (coverage == null) {
            return;
        }
        ICounter counter = coverage.getInstructionCounter();
        ImageDescriptor overlay = EclEmmaUIPlugin.getCoverageOverlay(counter.getRatio());
        decoration.addOverlay(overlay, 0);
        decoration.addSuffix(SUFFIX_FORMAT.format(new Double(counter.getRatio())));
    }

    protected void fireEvent() {
        IWorkbench workbench = EclEmmaUIPlugin.getInstance().getWorkbench();
        if (workbench == null) {
            return;
        }
        final LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Iterator i = CoverageDecorator.this.listeners.iterator();
                while (i.hasNext()) {
                    ((ILabelProviderListener)i.next()).labelProviderChanged(event);
                }
            }
        });
    }

    public void addListener(ILabelProviderListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (this.coverageListener == null) {
            this.coverageListener = new IJavaCoverageListener(){

                public void coverageChanged() {
                    CoverageDecorator.this.fireEvent();
                }
            };
            CoverageTools.addJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        if (this.coverageListener != null) {
            CoverageTools.removeJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
            this.coverageListener = null;
        }
    }
}

