/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.wizards;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ISessionImporter;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.wizards.SessionImportPage1;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class SessionImportWizard
extends Wizard
implements IImportWizard {
    private static final String SETTINGSID = "SessionImportWizard";
    private SessionImportPage1 page1;

    public SessionImportWizard() {
        IDialogSettings pluginsettings = EclEmmaUIPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardsettings = pluginsettings.getSection(SETTINGSID);
        if (wizardsettings == null) {
            wizardsettings = pluginsettings.addNewSection(SETTINGSID);
        }
        this.setDialogSettings(wizardsettings);
        this.setWindowTitle(UIMessages.ImportSession_title);
        this.setDefaultPageImageDescriptor(EclEmmaUIPlugin.getImageDescriptor("icons/full/wizban/import_session.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page1 = new SessionImportPage1();
        this.addPage((IWizardPage)this.page1);
        super.addPages();
    }

    public boolean performFinish() {
        this.page1.saveWidgetValues();
        return this.importSession();
    }

    private boolean importSession() {
        final ISessionImporter importer = CoverageTools.getImporter();
        importer.setDescription(this.page1.getSessionDescription());
        importer.setCoverageFile(this.page1.getCoverageFile());
        importer.setClassFiles(this.page1.getClassFiles());
        importer.setCopy(this.page1.getCreateCopy());
        importer.setUseImportedMetaData(this.page1.getUseImportedMetaData());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    importer.importSession(monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ite) {
            Throwable ex = ite.getTargetException();
            EclEmmaUIPlugin.log(ex);
            String title = UIMessages.ImportReportErrorDialog_title;
            String msg = UIMessages.ImportReportErrorDialog_message;
            IStatus status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : EclEmmaUIPlugin.errorStatus(String.valueOf(ex.getMessage()), ex);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)msg, (IStatus)status);
            return false;
        }
        return true;
    }
}

