/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ICorePreferences;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionListener;
import com.mountainminds.eclemma.internal.ui.UIPreferences;
import com.mountainminds.eclemma.internal.ui.annotation.EditorTracker;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EclEmmaUIPlugin
extends AbstractUIPlugin {
    public static final String ID = "com.mountainminds.eclemma.ui";
    public static final String ID_COVERAGE_LAUNCH_GROUP = "com.mountainminds.eclemma.ui.launchGroup.coverage";
    public static final String ELCL_REFRESH = "icons/full/elcl16/refresh.gif";
    public static final String DLCL_REFRESH = "icons/full/dlcl16/refresh.gif";
    public static final String ELCL_IMPORT = "icons/full/elcl16/import.gif";
    public static final String DLCL_IMPORT = "icons/full/dlcl16/import.gif";
    public static final String ELCL_EXPORT = "icons/full/elcl16/export.gif";
    public static final String DLCL_EXPORT = "icons/full/dlcl16/export.gif";
    public static final String ELCL_REMOVE = "icons/full/elcl16/remove.gif";
    public static final String DLCL_REMOVE = "icons/full/dlcl16/remove.gif";
    public static final String ELCL_REMOVEALL = "icons/full/elcl16/removeall.gif";
    public static final String DLCL_REMOVEALL = "icons/full/dlcl16/removeall.gif";
    public static final String ELCL_MERGESESSIONS = "icons/full/elcl16/mergesessions.gif";
    public static final String DLCL_MERGESESSIONS = "icons/full/dlcl16/mergesessions.gif";
    public static final String ELCL_RELAUNCH = "icons/full/elcl16/relaunch.gif";
    public static final String DLCL_RELAUNCH = "icons/full/dlcl16/relaunch.gif";
    public static final String ELCL_SESSION = "icons/full/elcl16/session.gif";
    public static final String DLCL_SESSION = "icons/full/dlcl16/session.gif";
    public static final String ELCL_SHOWPROJECTS = "icons/full/elcl16/showprojects.gif";
    public static final String ELCL_SHOWPACKAGEROOTS = "icons/full/elcl16/showpackageroots.gif";
    public static final String ELCL_SHOWPACKAGES = "icons/full/elcl16/showpackages.gif";
    public static final String ELCL_SHOWTYPES = "icons/full/elcl16/showtypes.gif";
    public static final String ELCL_COLLAPSEALL = "icons/full/elcl16/collapseall.gif";
    public static final String ELCL_LINKED = "icons/full/elcl16/linked.gif";
    public static final String EVIEW_COVERAGE = "icons/full/eview16/coverage.gif";
    public static final String OBJ_SESSION = "icons/full/obj16/session.gif";
    private static final String[] OBJ_COVERAGE = new String[]{"icons/full/obj16/coverage00.gif", "icons/full/obj16/coverage01.gif", "icons/full/obj16/coverage02.gif", "icons/full/obj16/coverage03.gif", "icons/full/obj16/coverage04.gif", "icons/full/obj16/coverage05.gif", "icons/full/obj16/coverage06.gif", "icons/full/obj16/coverage07.gif", "icons/full/obj16/coverage08.gif", "icons/full/obj16/coverage09.gif", "icons/full/obj16/coverage10.gif", "icons/full/obj16/coverage11.gif", "icons/full/obj16/coverage12.gif"};
    private static final String[] OBJ_COVERAGE_OVERLAY = new String[]{"icons/full/ovr16/coverage00.gif", "icons/full/ovr16/coverage01.gif", "icons/full/ovr16/coverage02.gif", "icons/full/ovr16/coverage03.gif", "icons/full/ovr16/coverage04.gif", "icons/full/ovr16/coverage05.gif", "icons/full/ovr16/coverage06.gif", "icons/full/ovr16/coverage07.gif"};
    public static final String WIZBAN_EXPORT_SESSION = "icons/full/wizban/export_session.gif";
    public static final String WIZBAN_IMPORT_SESSION = "icons/full/wizban/import_session.gif";
    private static EclEmmaUIPlugin instance;
    private EditorTracker editorTracker;
    private ISessionListener sessionListener = new ISessionListener(){

        public void sessionAdded(ICoverageSession addedSession) {
            if (EclEmmaUIPlugin.this.getPreferenceStore().getBoolean("com.mountainminds.eclemma.ui.show_coverage_view")) {
                EclEmmaUIPlugin.this.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EclEmmaUIPlugin.this.showCoverageView();
                    }
                });
            }
        }

        public void sessionRemoved(ICoverageSession removedSession) {
        }

        public void sessionActivated(ICoverageSession session) {
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CoverageTools.setPreferences((ICorePreferences)UIPreferences.CORE_PREFERENCES);
        CoverageTools.getSessionManager().addSessionListener(this.sessionListener);
        this.editorTracker = new EditorTracker(this.getWorkbench());
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.editorTracker.dispose();
        CoverageTools.getSessionManager().removeSessionListener(this.sessionListener);
        super.stop(context);
    }

    public static EclEmmaUIPlugin getInstance() {
        return instance;
    }

    private void showCoverageView() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            try {
                IViewPart view = page.showView("com.mountainminds.eclemma.ui.CoverageView", null, 3);
                page.bringToTop((IWorkbenchPart)view);
            }
            catch (PartInitException e) {
                EclEmmaUIPlugin.log((CoreException)e);
            }
        }
    }

    public Shell getShell() {
        return this.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static IStatus errorStatus(String message, Throwable t) {
        return new Status(4, ID, 4, message, t);
    }

    public static void log(Throwable t) {
        String message = t.getMessage();
        if (message == null) {
            message = "Internal Error";
        }
        instance.getLog().log(EclEmmaUIPlugin.errorStatus(message, t));
    }

    public static void log(CoreException t) {
        instance.getLog().log(t.getStatus());
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return EclEmmaUIPlugin.loadImage(key).getDescriptor(key);
    }

    public static Image getImage(String key) {
        return EclEmmaUIPlugin.loadImage(key).get(key);
    }

    public static Image getCoverageImage(double ratio) {
        int idx = (int)Math.round(ratio * (double)OBJ_COVERAGE.length);
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= OBJ_COVERAGE.length) {
            idx = OBJ_COVERAGE.length - 1;
        }
        return EclEmmaUIPlugin.getImage(OBJ_COVERAGE[idx]);
    }

    public static ImageDescriptor getCoverageOverlay(double ratio) {
        int idx = (int)Math.round(ratio * (double)OBJ_COVERAGE_OVERLAY.length);
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= OBJ_COVERAGE_OVERLAY.length) {
            idx = OBJ_COVERAGE_OVERLAY.length - 1;
        }
        return EclEmmaUIPlugin.getImageDescriptor(OBJ_COVERAGE_OVERLAY[idx]);
    }

    private static ImageRegistry loadImage(String path) {
        ImageRegistry reg = EclEmmaUIPlugin.getInstance().getImageRegistry();
        if (reg.getDescriptor(path) == null) {
            URL url = instance.getBundle().getEntry(path);
            reg.put(path, ImageDescriptor.createFromURL((URL)url));
        }
        return reg;
    }
}

