/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;

public final class DebugOptions {
    private static final ITracer NUL_TRACER = new ITracer(){

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void trace(String message) {
        }

        @Override
        public void trace(String message, Object param1) {
        }

        @Override
        public void trace(String message, Object param1, Object param2) {
        }

        @Override
        public void trace(String message, Object param1, Object param2, Object param3) {
        }

        @Override
        public void startTimer() {
        }

        @Override
        public void stopTimer(String message) {
        }

        @Override
        public void startMemoryUsage() {
        }

        @Override
        public void stopMemoryUsage(String message) {
        }
    };
    private static final String KEYPREFIX_DEBUG = "com.mountainminds.eclemma.core/debug/";
    private static final String KEY_EMMAVERBOSITYLEVEL = "com.mountainminds.eclemma.core/debug/emmaVerbosityLevel";
    public static final String EMMAVERBOSITYLEVEL = DebugOptions.getOption("com.mountainminds.eclemma.core/debug/emmaVerbosityLevel", "silent");
    public static final ITracer PERFORMANCETRACER = DebugOptions.getTracer("performance");
    public static final ITracer INSTRUMENTATIONTRACER = DebugOptions.getTracer("instrumentation");
    public static final ITracer LAUNCHINGTRACER = DebugOptions.getTracer("launching");
    public static final ITracer ANALYSISTRACER = DebugOptions.getTracer("analysis");

    private static String getOption(String key, String defaultvalue) {
        String value = Platform.getDebugOption((String)key);
        return value == null ? defaultvalue : value;
    }

    private static ITracer getTracer(String channel) {
        String key = KEYPREFIX_DEBUG + channel;
        if (Boolean.valueOf(Platform.getDebugOption((String)key)).booleanValue()) {
            return new PrintStreamTracer(channel);
        }
        return NUL_TRACER;
    }

    public static interface ITracer {
        public boolean isEnabled();

        public void trace(String var1);

        public void trace(String var1, Object var2);

        public void trace(String var1, Object var2, Object var3);

        public void trace(String var1, Object var2, Object var3, Object var4);

        public void startTimer();

        public void stopTimer(String var1);

        public void startMemoryUsage();

        public void stopMemoryUsage(String var1);
    }

    private static class PrintStreamTracer
    implements ITracer {
        private final PrintStream out;
        private final String channel;
        private final ThreadLocal starttime = new ThreadLocal();
        private final ThreadLocal heapsize = new ThreadLocal();

        PrintStreamTracer(String channel) {
            this(channel, System.out);
        }

        PrintStreamTracer(String channel, PrintStream out) {
            this.channel = channel;
            this.out = out;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void trace(String message) {
            StringBuffer sb = new StringBuffer();
            sb.append('[').append(this.channel).append("] ").append(message);
            this.out.println(sb);
        }

        private void trace(String message, Object[] params) {
            this.trace(MessageFormat.format(message, params));
        }

        @Override
        public void trace(String message, Object param1) {
            this.trace(message, new Object[]{param1});
        }

        @Override
        public void trace(String message, Object param1, Object param2) {
            this.trace(message, new Object[]{param1, param2});
        }

        @Override
        public void trace(String message, Object param1, Object param2, Object param3) {
            this.trace(message, new Object[]{param1, param2, param3});
        }

        @Override
        public void startTimer() {
            this.starttime.set(new Long(System.currentTimeMillis()));
        }

        @Override
        public void stopTimer(String message) {
            Long start = (Long)this.starttime.get();
            if (start == null) {
                this.trace("Timer {0} not startet.", message);
            } else {
                long time = System.currentTimeMillis() - start;
                this.trace("{0} ms for {1}", new Object[]{new Long(time), message});
            }
        }

        @Override
        public void startMemoryUsage() {
            Runtime rt = Runtime.getRuntime();
            this.heapsize.set(new Long(rt.totalMemory() - rt.freeMemory()));
        }

        @Override
        public void stopMemoryUsage(String message) {
            Long start = (Long)this.heapsize.get();
            if (start == null) {
                this.trace("Memory usage for {0} not started.", message);
            } else {
                Runtime rt = Runtime.getRuntime();
                long bytes = rt.totalMemory() - rt.freeMemory() - start;
                this.trace("{0} bytes for {1}", new Object[]{new Long(bytes), message});
            }
        }
    }
}

