/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.IInstrumentation;
import com.mountainminds.eclemma.core.ISessionImporter;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SessionImporter
implements ISessionImporter {
    private String description;
    private String coveragefile;
    private IClassFiles[] classfiles;
    private boolean copy;
    private boolean useImportedMetaData;

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setCoverageFile(String file) {
        this.coveragefile = file;
    }

    @Override
    public void setClassFiles(IClassFiles[] classfiles) {
        this.classfiles = classfiles;
    }

    @Override
    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    @Override
    public void setUseImportedMetaData(boolean flag) {
        this.useImportedMetaData = flag;
    }

    @Override
    public void importSession(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CoreMessages.ImportingSession_task, 2);
        IInstrumentation[] instr = this.instrument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IPath[] cfiles = new IPath[]{this.createCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1))};
        ICoverageSession s = CoverageTools.createCoverageSession(this.description, instr, cfiles, null);
        CoverageTools.getSessionManager().addSession(s, true, null);
        monitor.done();
    }

    private IInstrumentation[] instrument(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", this.classfiles.length);
        IInstrumentation[] instr = new IInstrumentation[this.classfiles.length];
        int i = 0;
        while (i < this.classfiles.length) {
            if (this.useImportedMetaData) {
                instr[i] = new ExternalInstrumentation(this.classfiles[i], this.coveragefile);
                monitor.worked(1);
            } else {
                instr[i] = this.classfiles[i].instrument(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            ++i;
        }
        monitor.done();
        return instr;
    }

    private IPath createCopy(IProgressMonitor monitor) throws CoreException {
        IPath file = Path.fromOSString((String)this.coveragefile);
        if (this.copy) {
            file = EclEmmaCorePlugin.getInstance().getStateFiles().getImportSessionFile(file);
            File source = new File(this.coveragefile);
            monitor.beginTask("", (int)source.length());
            byte[] buffer = new byte[4096];
            try {
                int l;
                FileInputStream in = new FileInputStream(source);
                FileOutputStream out = new FileOutputStream(file.toFile());
                while ((l = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, l);
                    monitor.worked(l);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                throw new CoreException(EclEmmaStatus.IMPORT_ERROR.getStatus(e));
            }
        }
        monitor.done();
        return file;
    }

    private static class ExternalInstrumentation
    implements IInstrumentation {
        private final IClassFiles classfiles;
        private final IPath metaDataFile;

        ExternalInstrumentation(IClassFiles classfiles, String metaDataFile) {
            this.classfiles = classfiles;
            this.metaDataFile = Path.fromOSString((String)metaDataFile);
        }

        @Override
        public IClassFiles getClassFiles() {
            return this.classfiles;
        }

        @Override
        public IPath getMetaDataFile() {
            return this.metaDataFile;
        }

        @Override
        public IPath getOutputLocation() {
            throw new UnsupportedOperationException("Unsupported for imported sessions.");
        }

        @Override
        public boolean isInplace() {
            throw new UnsupportedOperationException("Unsupported for imported sessions.");
        }
    }
}

