/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.analysis.ICounter;
import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.core.analysis.ILineCoverage;
import com.mountainminds.eclemma.internal.core.analysis.Counter;
import com.mountainminds.eclemma.internal.core.analysis.Lines;
import org.eclipse.core.resources.IResource;

public class JavaElementCoverage
implements IJavaElementCoverage {
    private Counter typeCounter;
    private Counter methodCounter;
    private Counter blockCounter;
    private Counter lineCounter;
    private Counter instructionsCounter;
    private final JavaElementCoverage parent;
    private final Lines lines;
    private final long modificationStamp;

    public JavaElementCoverage(JavaElementCoverage parent, boolean haslines, long stamp) {
        this.parent = parent;
        this.typeCounter = Counter.COUNTER_0_0;
        this.methodCounter = Counter.COUNTER_0_0;
        this.blockCounter = Counter.COUNTER_0_0;
        this.instructionsCounter = Counter.COUNTER_0_0;
        this.lineCounter = haslines ? null : Counter.COUNTER_0_0;
        this.modificationStamp = stamp;
        this.lines = haslines ? new Lines() : null;
    }

    public JavaElementCoverage(JavaElementCoverage parent, boolean haslines, IResource resource) {
        this(parent, haslines, resource == null ? 0L : resource.getModificationStamp());
    }

    public void addBlock(int instructions, int[] lines, boolean covered) {
        this.addBlock(instructions, lines, covered, 0, 0);
    }

    private void addBlock(int instructions, int[] lines, boolean covered, int totalLineDelta, int coveredLineDelta) {
        this.blockCounter = this.blockCounter.increment(1, covered ? 1 : 0);
        this.instructionsCounter = this.instructionsCounter.increment(instructions, covered ? instructions : 0);
        if (this.lines == null) {
            this.lineCounter = this.lineCounter.increment(totalLineDelta, coveredLineDelta);
            if (this.parent != null) {
                this.parent.addBlock(instructions, lines, covered, totalLineDelta, coveredLineDelta);
            }
        } else if (lines != null) {
            long totalDelta = this.lines.getTotalCount();
            long coveredDelta = this.lines.getCoveredCount();
            this.lines.addLines(lines, covered);
            if (this.parent != null) {
                totalDelta = this.lines.getTotalCount() - totalDelta;
                coveredDelta = this.lines.getCoveredCount() - coveredDelta;
                this.parent.addBlock(instructions, lines, covered, (int)totalDelta, (int)coveredDelta);
            }
        }
    }

    public void addMethod(boolean covered) {
        this.methodCounter = this.methodCounter.increment(1, covered ? 1 : 0);
        if (this.parent != null) {
            this.parent.addMethod(covered);
        }
    }

    public void addType(boolean covered) {
        this.typeCounter = this.typeCounter.increment(1, covered ? 1 : 0);
        if (this.parent != null) {
            this.parent.addType(covered);
        }
    }

    @Override
    public ICounter getBlockCounter() {
        return this.blockCounter;
    }

    @Override
    public ICounter getLineCounter() {
        if (this.lines == null) {
            return this.lineCounter;
        }
        return this.lines;
    }

    @Override
    public ICounter getInstructionCounter() {
        return this.instructionsCounter;
    }

    @Override
    public ILineCoverage getLineCoverage() {
        return this.lines;
    }

    @Override
    public ICounter getMethodCounter() {
        return this.methodCounter;
    }

    @Override
    public ICounter getTypeCounter() {
        return this.typeCounter;
    }

    @Override
    public long getResourceModificationStamp() {
        return this.modificationStamp;
    }
}

