/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.launching;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.IInstrumentation;
import com.mountainminds.eclemma.core.launching.ICoverageLaunchInfo;
import com.mountainminds.eclemma.internal.core.DebugOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.JavaRuntime;

public class InstrumentedClasspathProvider
implements IRuntimeClasspathProvider {
    public static final String ID = "com.mountainminds.eclemma.core.instrumentedClasspathProvider";
    private static final DebugOptions.ITracer TRACER = DebugOptions.LAUNCHINGTRACER;
    private static final ThreadLocal originalClasspathProvider = new ThreadLocal();
    private static final ThreadLocal launchInfo = new ThreadLocal();

    public static void enable(IRuntimeClasspathProvider originalClasspathProvider, ICoverageLaunchInfo launchInfo) {
        InstrumentedClasspathProvider.originalClasspathProvider.set(originalClasspathProvider);
        InstrumentedClasspathProvider.launchInfo.set(launchInfo);
    }

    public static void disable() {
        originalClasspathProvider.set(null);
        launchInfo.set(null);
    }

    private static IRuntimeClasspathProvider getOriginalClasspathProvider() throws CoreException {
        Object obj = originalClasspathProvider.get();
        if (obj == null) {
            throw new CoreException(EclEmmaStatus.INVALID_CLASSPATH_PROVIDER_CONTEXT_ERROR.getStatus(null));
        }
        return (IRuntimeClasspathProvider)obj;
    }

    private static ICoverageLaunchInfo getLaunchInfo() throws CoreException {
        Object obj = launchInfo.get();
        if (obj == null) {
            throw new CoreException(EclEmmaStatus.INVALID_CLASSPATH_PROVIDER_CONTEXT_ERROR.getStatus(null));
        }
        return (ICoverageLaunchInfo)obj;
    }

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = InstrumentedClasspathProvider.getOriginalClasspathProvider().computeUnresolvedClasspath(configuration);
        TRACER.trace("computeUnresolvedClasspath() -> {0}", Arrays.asList(entries));
        return entries;
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        TRACER.trace("resolveClasspath()");
        ICoverageLaunchInfo info = InstrumentedClasspathProvider.getLaunchInfo();
        entries = InstrumentedClasspathProvider.getOriginalClasspathProvider().resolveClasspath(entries, configuration);
        ArrayList<IRuntimeClasspathEntry> newentries = new ArrayList<IRuntimeClasspathEntry>();
        boolean emmartinserted = false;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getClasspathProperty() == 3) {
                TRACER.trace("Resolved classpath entry: {0}", entries[i].getLocation());
                IInstrumentation instr = info.getInstrumentation(entries[i].getLocation());
                if (instr != null) {
                    TRACER.trace("Found instrumented classes for {0}", entries[i].getLocation());
                    if (!emmartinserted) {
                        this.addEmmaRuntime(info, newentries);
                        emmartinserted = true;
                    }
                    if (!instr.isInplace()) {
                        newentries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)instr.getOutputLocation()));
                    }
                }
            }
            newentries.add(entries[i]);
            ++i;
        }
        IRuntimeClasspathEntry[] arr = new IRuntimeClasspathEntry[newentries.size()];
        return newentries.toArray(arr);
    }

    protected void addEmmaRuntime(ICoverageLaunchInfo info, List entries) throws CoreException {
        IPath propertiesjarpath = info.getPropertiesJARFile();
        entries.add(0, JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)propertiesjarpath));
        entries.add(0, JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)CoverageTools.getEmmaJar()));
    }
}

