/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.core.analysis.IJavaModelCoverage;
import com.mountainminds.eclemma.internal.core.analysis.ILazyBinding;
import com.mountainminds.eclemma.internal.core.analysis.JavaElementCoverage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;

public class JavaModelCoverage
extends JavaElementCoverage
implements IJavaModelCoverage {
    private final Map coveragemap = new HashMap();
    private final List projects = new ArrayList();
    private final List fragmentroots = new ArrayList();
    private final List fragments = new ArrayList();
    private final List types = new ArrayList();

    public JavaModelCoverage() {
        super(null, false, 0L);
    }

    public void put(IJavaElement element, IJavaElementCoverage coverage) {
        this.coveragemap.put(element, coverage);
        switch (element.getElementType()) {
            case 2: {
                this.projects.add(element);
                break;
            }
            case 3: {
                this.fragmentroots.add(element);
                break;
            }
            case 4: {
                this.fragments.add(element);
                break;
            }
            case 7: {
                this.types.add(element);
            }
        }
    }

    public IJavaProject[] getInstrumentedProjects() {
        IJavaProject[] arr = new IJavaProject[this.projects.size()];
        return this.projects.toArray(arr);
    }

    public IPackageFragmentRoot[] getInstrumentedPackageFragmentRoots() {
        IPackageFragmentRoot[] arr = new IPackageFragmentRoot[this.fragmentroots.size()];
        return this.fragmentroots.toArray(arr);
    }

    public IPackageFragment[] getInstrumentedPackageFragments() {
        IPackageFragment[] arr = new IPackageFragment[this.fragments.size()];
        return this.fragments.toArray(arr);
    }

    public IType[] getInstrumentedTypes() {
        IType[] arr = new IType[this.types.size()];
        return this.types.toArray(arr);
    }

    public IJavaElementCoverage getCoverageFor(IJavaElement element) {
        IJavaElementCoverage c = (IJavaElementCoverage)this.coveragemap.get(element);
        if (c == null && element.getElementType() == 9) {
            IJavaElement parent = element.getParent();
            IJavaElementCoverage parentcoverage = this.getCoverageFor(parent);
            if (parentcoverage instanceof ILazyBinding) {
                ((ILazyBinding)((Object)parentcoverage)).resolve(parent, this);
            }
            c = (IJavaElementCoverage)this.coveragemap.get(element);
        }
        return c;
    }
}

