/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.core.analysis.ILineCoverage;
import com.mountainminds.eclemma.internal.core.analysis.Counter;

public class Lines
extends Counter
implements ILineCoverage {
    private static final int BLOCK_INCREMENT = 64;
    private byte[] coverage = null;
    private int firstline = 0;
    private int lastline = 0;
    private int offset = 0;

    protected Lines() {
        super(0L, 0L);
    }

    private int getBlockAlignedOffset(int line) {
        return line - line % 64;
    }

    private int getBlockAlignedSize(int size) {
        return size + 64 - size % 64;
    }

    private void ensureCapacity(int line) {
        if (this.coverage == null) {
            this.firstline = line;
            this.lastline = line;
            this.offset = this.getBlockAlignedOffset(line);
            this.coverage = new byte[64];
            return;
        }
        if (this.firstline > line) {
            this.firstline = line;
            if (this.offset > line) {
                int newoffset = this.getBlockAlignedOffset(line);
                byte[] newcoverage = new byte[this.coverage.length + this.offset - newoffset];
                System.arraycopy(this.coverage, 0, newcoverage, this.offset - newoffset, this.coverage.length);
                this.offset = newoffset;
                this.coverage = newcoverage;
            }
            return;
        }
        if (this.lastline < line) {
            this.lastline = line;
            if (line - this.offset >= this.coverage.length) {
                byte[] newcoverage = new byte[this.getBlockAlignedSize(line - this.offset)];
                System.arraycopy(this.coverage, 0, newcoverage, 0, this.coverage.length);
                this.coverage = newcoverage;
            }
        }
    }

    public void addLines(int[] lines, boolean isCovered) {
        int i = 0;
        while (i < lines.length) {
            int line = lines[i];
            this.ensureCapacity(line);
            int idx = line - this.offset;
            switch (this.coverage[idx]) {
                case 0: {
                    ++this.total;
                    if (!isCovered) break;
                    ++this.covered;
                    break;
                }
                case 1: {
                    if (!isCovered) break;
                    ++this.covered;
                }
            }
            int n = idx;
            this.coverage[n] = (byte)(this.coverage[n] | (isCovered ? 2 : 1));
            ++i;
        }
    }

    public Counter increment(int total, int covered) {
        throw new UnsupportedOperationException();
    }

    public byte[] getCoverage() {
        return this.coverage;
    }

    public int getFirstLine() {
        return this.firstline;
    }

    public int getLastLine() {
        return this.lastline;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte getCoverage(int line) {
        if (this.coverage == null || line < this.firstline || line > this.lastline) {
            return 0;
        }
        return this.coverage[line - this.offset];
    }
}

