/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.instr;

import com.mountainminds.eclemma.core.IClassFiles;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import com.mountainminds.eclemma.internal.core.instr.ClassFiles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public class ClassFilesStore {
    private final Map locationIndex = new HashMap();

    public void add(IPackageFragmentRoot root) throws JavaModelException {
        IPath location = ClassFilesStore.getClassFileLocation(root);
        String absolute = EclEmmaCorePlugin.getAbsolutePath(location).toOSString();
        ClassFiles classfiles = (ClassFiles)this.locationIndex.get(absolute);
        classfiles = classfiles == null ? new ClassFiles(root, location) : classfiles.addRoot(root);
        this.locationIndex.put(absolute, classfiles);
    }

    public void add(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            this.add(roots[i]);
            ++i;
        }
    }

    public void add(IJavaModel javaModel) throws JavaModelException {
        IJavaProject[] javaProjects = javaModel.getJavaProjects();
        int i = 0;
        while (i < javaProjects.length) {
            this.add(javaProjects[i]);
            ++i;
        }
    }

    public IClassFiles[] getClassFiles() {
        ArrayList l = new ArrayList(this.locationIndex.values());
        return l.toArray(new IClassFiles[l.size()]);
    }

    public IClassFiles getAtAbsoluteLocation(String location) {
        return (IClassFiles)this.locationIndex.get(location);
    }

    private static IPath getClassFileLocation(IPackageFragmentRoot root) throws JavaModelException {
        IPath path;
        if (root.getKind() == 1) {
            IClasspathEntry entry = root.getRawClasspathEntry();
            path = entry.getOutputLocation();
            if (path == null) {
                path = root.getJavaProject().getOutputLocation();
            }
        } else {
            path = root.getPath();
        }
        return path;
    }
}

