/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.instr;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.ISourceLocation;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.EclEmmaCorePlugin;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

public class SourceLocation
implements ISourceLocation {
    private static final String JAVA_EXT = ".java";
    private IPath path;
    private IPath rootpath;

    public static ISourceLocation findLocation(IPackageFragmentRoot root) throws JavaModelException {
        if (root.getKind() == 1) {
            IPath path = EclEmmaCorePlugin.getAbsolutePath(root.getPath());
            return new SourceLocation(path, (IPath)new Path(""));
        }
        IPath path = root.getSourceAttachmentPath();
        if (path != null) {
            path = EclEmmaCorePlugin.getAbsolutePath(path);
            return new SourceLocation(path, root.getSourceAttachmentRootPath());
        }
        return null;
    }

    public static ISourceLocation[] findLocations(IPackageFragmentRoot[] roots) throws JavaModelException {
        ArrayList<ISourceLocation> l = new ArrayList<ISourceLocation>();
        int i = 0;
        while (i < roots.length) {
            ISourceLocation loc = SourceLocation.findLocation(roots[i]);
            if (loc != null) {
                l.add(loc);
            }
            ++i;
        }
        return l.toArray(new ISourceLocation[l.size()]);
    }

    public SourceLocation(IPath path, IPath rootpath) {
        this.path = path;
        this.rootpath = rootpath;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getRootPath() {
        return this.rootpath;
    }

    public boolean isArchive() {
        return this.path.toFile().isFile();
    }

    public void extract(IProgressMonitor monitor) throws CoreException {
        if (this.isArchive()) {
            monitor.beginTask(NLS.bind((String)CoreMessages.ExtractingSourceArchive_task, (Object)this.path), 1);
            String prefix = this.rootpath == null ? "" : this.rootpath.toString();
            byte[] buffer = new byte[4096];
            IPath srcfolder = EclEmmaCorePlugin.getInstance().getStateFiles().getSourceFolder(this.path);
            if (!srcfolder.toFile().exists()) {
                try {
                    ZipEntry entry;
                    ZipInputStream zip = new ZipInputStream(new FileInputStream(this.path.toFile()));
                    while ((entry = zip.getNextEntry()) != null) {
                        if (!entry.isDirectory() && entry.getName().startsWith(prefix) && entry.getName().endsWith(JAVA_EXT)) {
                            int len;
                            IPath path = srcfolder.append(entry.getName().substring(prefix.length()));
                            path.removeLastSegments(1).toFile().mkdirs();
                            FileOutputStream out = new FileOutputStream(path.toFile());
                            while ((len = zip.read(buffer)) != -1) {
                                ((OutputStream)out).write(buffer, 0, len);
                            }
                            ((OutputStream)out).close();
                        }
                        zip.closeEntry();
                    }
                    zip.close();
                }
                catch (IOException e) {
                    throw new CoreException(EclEmmaStatus.SOURCE_EXTRACTION_ERROR.getStatus(this.path, e));
                }
            }
            this.path = srcfolder;
            this.rootpath = null;
        }
        monitor.done();
    }
}

