/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.coverageview;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionListener;
import com.mountainminds.eclemma.core.analysis.ICounter;
import com.mountainminds.eclemma.core.analysis.IJavaCoverageListener;
import com.mountainminds.eclemma.core.analysis.IJavaElementCoverage;
import com.mountainminds.eclemma.internal.ui.ContextHelp;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.actions.ExportSessionAction;
import com.mountainminds.eclemma.internal.ui.actions.ImportSessionAction;
import com.mountainminds.eclemma.internal.ui.actions.MergeSessionsAction;
import com.mountainminds.eclemma.internal.ui.actions.RefreshSessionAction;
import com.mountainminds.eclemma.internal.ui.actions.RemoveActiveSessionAction;
import com.mountainminds.eclemma.internal.ui.actions.RemoveAllSessionsAction;
import com.mountainminds.eclemma.internal.ui.coverageview.CollapseAllAction;
import com.mountainminds.eclemma.internal.ui.coverageview.CopyAction;
import com.mountainminds.eclemma.internal.ui.coverageview.CoverageViewSorter;
import com.mountainminds.eclemma.internal.ui.coverageview.CoveredElementsContentProvider;
import com.mountainminds.eclemma.internal.ui.coverageview.HideUnusedTypesAction;
import com.mountainminds.eclemma.internal.ui.coverageview.LinkWithSelectionAction;
import com.mountainminds.eclemma.internal.ui.coverageview.RelaunchSessionAction;
import com.mountainminds.eclemma.internal.ui.coverageview.SelectCounterModeAction;
import com.mountainminds.eclemma.internal.ui.coverageview.SelectEntryModeAction;
import com.mountainminds.eclemma.internal.ui.coverageview.SelectSessionAction;
import com.mountainminds.eclemma.internal.ui.coverageview.SelectionTracker;
import com.mountainminds.eclemma.internal.ui.coverageview.TreeSortCompatibility;
import com.mountainminds.eclemma.internal.ui.coverageview.ViewSettings;
import java.text.DecimalFormat;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class CoverageView
extends ViewPart
implements IShowInTarget {
    public static final String ID = "com.mountainminds.eclemma.ui.CoverageView";
    public static final Object LOADING_ELEMENT = new Object();
    private static final DecimalFormat COVERAGE_VALUE = new DecimalFormat(UIMessages.CoverageView_columnCoverageValue);
    private ViewSettings settings = new ViewSettings();
    protected static final int COLUMN_ELEMENT = 0;
    protected static final int COLUMN_RATIO = 1;
    protected static final int COLUMN_COVERED = 2;
    protected static final int COLUMN_MISSED = 3;
    protected static final int COLUMN_TOTAL = 4;
    private Tree tree;
    private TreeColumn column0;
    private TreeColumn column1;
    private TreeColumn column2;
    private TreeColumn column3;
    private TreeColumn column4;
    private TreeViewer viewer;
    private OpenAction openAction;
    private IAction copyAction;
    private IAction relaunchSessionAction;
    private IAction removeActiveSessionAction;
    private IAction removeAllSessionsAction;
    private IAction mergeSessionsAction;
    private IAction selectSessionAction;
    private IAction importAction;
    private IAction exportAction;
    private IAction refreshAction;
    private PropertyDialogAction propertiesAction;
    private SelectionTracker selectiontracker;
    private CoverageViewSorter sorter = new CoverageViewSorter(this.settings, this);
    private ISessionListener listener = new ISessionListener(){

        public void sessionAdded(ICoverageSession newSession) {
            CoverageView.this.updateActions();
        }

        public void sessionRemoved(ICoverageSession oldSession) {
            CoverageView.this.updateActions();
        }

        public void sessionActivated(ICoverageSession session) {
            CoverageView.this.updateActions();
        }
    };
    private IJavaCoverageListener coverageListener = new IJavaCoverageListener(){

        public void coverageChanged() {
            CoverageView.this.tree.getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    CoverageView.access$1(2.access$0(this.this$1)).setInput((Object)CoverageTools.getJavaModelCoverage());
                }
            });
        }

        static /* synthetic */ CoverageView access$0(2 var0) {
            return var0.CoverageView.this;
        }
    };
    private ITableLabelProvider labelprovider = new ITableLabelProvider(){
        private ILabelProvider delegate = new WorkbenchLabelProvider();

        public Image getColumnImage(Object element, int columnIndex) {
            if (element == LOADING_ELEMENT) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return this.delegate.getImage(element);
                }
                case 1: {
                    ICounter counter = CoverageView.this.settings.getCounterMode().getCounter(CoverageTools.getCoverageInfo((Object)element));
                    if (counter.getTotalCount() == 0L) {
                        return null;
                    }
                    return EclEmmaUIPlugin.getCoverageImage(counter.getRatio());
                }
            }
            return null;
        }

        private String getSimpleTextForJavaElement(Object element) {
            IPackageFragmentRoot root;
            if (element instanceof IPackageFragmentRoot && (root = (IPackageFragmentRoot)element).getElementName().length() == 0) {
                element = root.getJavaProject();
            }
            return this.delegate.getText(element);
        }

        private String getTextForJavaElement(Object element) {
            String text = this.getSimpleTextForJavaElement(element);
            switch (CoverageView.this.settings.getEntryMode()) {
                case 2: {
                    if (!(element instanceof IPackageFragmentRoot)) break;
                    text = String.valueOf(text) + " - " + this.getTextForJavaElement(((IPackageFragmentRoot)element).getJavaProject());
                }
            }
            return text;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == LOADING_ELEMENT) {
                return columnIndex == 0 ? UIMessages.CoverageView_loadingMessage : "";
            }
            ICounter counter = CoverageView.this.settings.getCounterMode().getCounter(CoverageTools.getCoverageInfo((Object)element));
            switch (columnIndex) {
                case 0: {
                    return this.getTextForJavaElement(element);
                }
                case 1: {
                    if (counter.getTotalCount() == 0L) {
                        return "";
                    }
                    return COVERAGE_VALUE.format(new Double(counter.getRatio()));
                }
                case 2: {
                    return String.valueOf(counter.getCoveredCount());
                }
                case 3: {
                    return String.valueOf(counter.getMissedCount());
                }
                case 4: {
                    return String.valueOf(counter.getTotalCount());
                }
            }
            return "";
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.delegate.isLabelProperty(element, property);
        }

        public void addListener(ILabelProviderListener listener) {
            this.delegate.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.delegate.removeListener(listener);
        }

        public void dispose() {
            this.delegate.dispose();
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.settings.init(memento);
    }

    public void saveState(IMemento memento) {
        int[] widths = this.settings.getColumnWidths();
        widths[0] = this.column0.getWidth();
        widths[1] = this.column1.getWidth();
        widths[2] = this.column2.getWidth();
        widths[3] = this.column3.getWidth();
        widths[4] = this.column4.getWidth();
        this.settings.save(memento);
        super.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        ContextHelp.setHelp((Control)parent, "com.mountainminds.eclemma.ui.coverage_view_context");
        this.tree = new Tree(parent, 2);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        int[] widths = this.settings.getColumnWidths();
        this.column0 = new TreeColumn(this.tree, 0);
        this.column0.setWidth(widths[0]);
        this.sorter.addColumn(this.column0, 0);
        this.column1 = new TreeColumn(this.tree, 131072);
        this.column1.setWidth(widths[1]);
        this.sorter.addColumn(this.column1, 1);
        this.column2 = new TreeColumn(this.tree, 131072);
        this.column2.setWidth(widths[2]);
        this.sorter.addColumn(this.column2, 2);
        this.column3 = new TreeColumn(this.tree, 131072);
        this.column3.setWidth(widths[3]);
        this.sorter.addColumn(this.column3, 3);
        this.column4 = new TreeColumn(this.tree, 131072);
        this.column4.setWidth(widths[4]);
        this.sorter.addColumn(this.column4, 4);
        this.updateColumnHeaders();
        TreeColumn sortColumn = null;
        switch (this.settings.getSortColumn()) {
            case 0: {
                sortColumn = this.column0;
                break;
            }
            case 1: {
                sortColumn = this.column1;
                break;
            }
            case 2: {
                sortColumn = this.column2;
                break;
            }
            case 3: {
                sortColumn = this.column3;
                break;
            }
            case 4: {
                sortColumn = this.column4;
            }
        }
        TreeSortCompatibility.setTreeSortColumnAndDirection(sortColumn, this.settings.isReverseSort() ? 1024 : 128);
        this.viewer = new TreeViewer(this.tree);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element == LOADING_ELEMENT) {
                    return true;
                }
                IJavaElementCoverage c = CoverageTools.getCoverageInfo((Object)element);
                if (c == null || c.getInstructionCounter().getTotalCount() == 0L) {
                    return false;
                }
                if (CoverageView.this.settings.getHideUnusedTypes()) {
                    ICounter cnt = c.getTypeCounter();
                    return cnt.getTotalCount() == 0L || cnt.getCoveredCount() != 0L;
                }
                return true;
            }
        });
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.viewer.setContentProvider((IContentProvider)new CoveredElementsContentProvider(this.settings));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelprovider);
        this.viewer.setInput((Object)CoverageTools.getJavaModelCoverage());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CoverageView.this.openAction.selectionChanged((IStructuredSelection)event.getSelection());
                CoverageView.this.propertiesAction.selectionChanged(event);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.selectiontracker = new SelectionTracker((IViewPart)this, (StructuredViewer)this.viewer);
        this.createActions();
        this.updateActions();
        this.configureToolbar();
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CoverageView.this.openAction.run((IStructuredSelection)event.getSelection());
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        this.tree.setMenu(menuMgr.createContextMenu((Control)this.tree));
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                CoverageView.this.configureContextMenu(menuMgr);
            }
        });
        CoverageTools.getSessionManager().addSessionListener(this.listener);
        CoverageTools.addJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
    }

    protected void createActions() {
        IKeyBindingService kb = this.getSite().getKeyBindingService();
        IActionBars ab = this.getViewSite().getActionBars();
        this.openAction = new OpenAction((IWorkbenchSite)this.getSite());
        this.openAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        ab.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)this.openAction);
        this.openAction.setEnabled(false);
        this.copyAction = new CopyAction(this.tree.getDisplay(), this.settings, this.labelprovider, (ISelectionProvider)this.viewer);
        ab.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
        this.relaunchSessionAction = new RelaunchSessionAction();
        kb.registerAction(this.relaunchSessionAction);
        this.removeActiveSessionAction = new RemoveActiveSessionAction();
        ab.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.removeActiveSessionAction);
        this.removeAllSessionsAction = new RemoveAllSessionsAction();
        kb.registerAction(this.removeAllSessionsAction);
        this.mergeSessionsAction = new MergeSessionsAction(this.getSite().getWorkbenchWindow());
        kb.registerAction(this.mergeSessionsAction);
        this.selectSessionAction = new SelectSessionAction();
        kb.registerAction(this.selectSessionAction);
        this.importAction = new ImportSessionAction(this.getSite().getWorkbenchWindow());
        kb.registerAction(this.importAction);
        this.exportAction = new ExportSessionAction(this.getSite().getWorkbenchWindow());
        kb.registerAction(this.exportAction);
        this.refreshAction = new RefreshSessionAction();
        ab.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.refreshAction);
        this.propertiesAction = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        this.propertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        ab.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
    }

    protected void configureToolbar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IContributionItem)new Separator("additions"));
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.relaunchSessionAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.removeActiveSessionAction);
        tbm.add(this.removeAllSessionsAction);
        tbm.add(this.mergeSessionsAction);
        tbm.add(this.selectSessionAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new CollapseAllAction(this.viewer));
        tbm.add((IAction)new LinkWithSelectionAction(this.settings, this.selectiontracker));
        IMenuManager mm = this.getViewSite().getActionBars().getMenuManager();
        mm.add((IAction)new SelectEntryModeAction(1, this.settings, this));
        mm.add((IAction)new SelectEntryModeAction(2, this.settings, this));
        mm.add((IAction)new SelectEntryModeAction(3, this.settings, this));
        mm.add((IAction)new SelectEntryModeAction(4, this.settings, this));
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)new SelectCounterModeAction(0, this.settings, this));
        mm.add((IAction)new SelectCounterModeAction(1, this.settings, this));
        mm.add((IAction)new SelectCounterModeAction(2, this.settings, this));
        mm.add((IAction)new SelectCounterModeAction(3, this.settings, this));
        mm.add((IAction)new SelectCounterModeAction(4, this.settings, this));
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)new HideUnusedTypesAction(this.settings, this));
        mm.add((IContributionItem)new Separator());
        mm.add((IContributionItem)new Separator("additions"));
    }

    public void configureContextMenu(IMenuManager mm) {
        mm.add((IAction)this.openAction);
        mm.add((IContributionItem)new Separator());
        mm.add(this.copyAction);
        mm.add((IContributionItem)new Separator());
        mm.add(this.importAction);
        mm.add(this.exportAction);
        mm.add((IContributionItem)new Separator());
        mm.add(this.refreshAction);
        mm.add((IContributionItem)new Separator("additions"));
        mm.add((IAction)this.propertiesAction);
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void dispose() {
        CoverageTools.removeJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
        CoverageTools.getSessionManager().removeSessionListener(this.listener);
        this.selectiontracker.dispose();
        super.dispose();
    }

    protected void updateColumnHeaders() {
        String[] columns = this.settings.getCounterMode().getColumnHeaders();
        this.column0.setText(columns[0]);
        this.column1.setText(columns[1]);
        this.column2.setText(columns[2]);
        this.column3.setText(columns[3]);
        this.column4.setText(columns[4]);
    }

    protected void updateActions() {
        this.tree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ICoverageSession active = CoverageTools.getSessionManager().getActiveSession();
                CoverageView.this.setContentDescription(active == null ? "" : active.getDescription());
                CoverageView.this.relaunchSessionAction.setEnabled(active != null && active.getLaunchConfiguration() != null);
                ICoverageSession[] sessions = CoverageTools.getSessionManager().getSessions();
                boolean atLeastOne = sessions.length >= 1;
                CoverageView.this.removeActiveSessionAction.setEnabled(atLeastOne);
                CoverageView.this.removeAllSessionsAction.setEnabled(atLeastOne);
                CoverageView.this.exportAction.setEnabled(atLeastOne);
                CoverageView.this.refreshAction.setEnabled(atLeastOne);
                CoverageView.this.selectSessionAction.setEnabled(atLeastOne);
                boolean atLeastTwo = sessions.length >= 2;
                CoverageView.this.mergeSessionsAction.setEnabled(atLeastTwo);
            }
        });
    }

    protected void refreshViewer() {
        this.viewer.refresh();
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.viewer.setSelection(selection);
            return true;
        }
        return false;
    }

    static /* synthetic */ TreeViewer access$1(CoverageView coverageView) {
        return coverageView.viewer;
    }
}

