/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.coverageview;

import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.coverageview.CoverageView;
import com.mountainminds.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.jface.action.Action;

class SelectEntryModeAction
extends Action {
    private final ViewSettings settings;
    private final int mode;
    private final CoverageView view;

    SelectEntryModeAction(int mode, ViewSettings settings, CoverageView view) {
        super(null, 8);
        this.mode = mode;
        this.settings = settings;
        this.view = view;
        this.setChecked(mode == settings.getEntryMode());
        String iconkey = null;
        switch (mode) {
            case 1: {
                this.setText(UIMessages.CoverageViewShowProjectsAction_label);
                this.setToolTipText(UIMessages.CoverageViewShowProjectsAction_tooltip);
                iconkey = "icons/full/elcl16/showprojects.gif";
                break;
            }
            case 2: {
                this.setText(UIMessages.CoverageViewShowPackageRootsAction_label);
                this.setToolTipText(UIMessages.CoverageViewShowPackageRootsAction_tooltip);
                iconkey = "icons/full/elcl16/showpackageroots.gif";
                break;
            }
            case 3: {
                this.setText(UIMessages.CoverageViewShowPackagesAction_label);
                this.setToolTipText(UIMessages.CoverageViewShowPackagesAction_tooltip);
                iconkey = "icons/full/elcl16/showpackages.gif";
                break;
            }
            case 4: {
                this.setText(UIMessages.CoverageViewShowTypesAction_label);
                this.setToolTipText(UIMessages.CoverageViewShowTypesAction_tooltip);
                iconkey = "icons/full/elcl16/showtypes.gif";
            }
        }
        this.setImageDescriptor(EclEmmaUIPlugin.getImageDescriptor(iconkey));
    }

    public void run() {
        this.settings.setEntryMode(this.mode);
        this.view.refreshViewer();
    }
}

