/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.wizards;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionExporter;
import com.mountainminds.eclemma.internal.ui.ContextHelp;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.wizards.ComboHistory;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SessionExportPage1
extends WizardPage {
    private static final String ID = "SessionExportPage1";
    private static final String STORE_PREFIX = "SessionExportPage1.";
    private static final String STORE_FORMAT = "SessionExportPage1.format";
    private static final String STORE_DESTINATIONS = "SessionExportPage1.destinations";
    private static final String STORE_OPENREPORT = "SessionExportPage1.openreport";
    private TableViewer sessionstable;
    private Combo formatcombo;
    private Combo destinationcombo;
    private Button opencheckbox;

    public SessionExportPage1() {
        super(ID);
        this.setTitle(UIMessages.ExportReportPage1_title);
        this.setDescription(UIMessages.ExportReportPage1_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout());
        new Label(parent, 0).setText(UIMessages.ExportReportPage1Sessions_label);
        this.sessionstable = new TableViewer(parent, 2048);
        this.sessionstable.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.sessionstable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sessionstable.setInput((Object)CoverageTools.getSessionManager().getSessions());
        ICoverageSession active = CoverageTools.getSessionManager().getActiveSession();
        if (active != null) {
            this.sessionstable.setSelection((ISelection)new StructuredSelection((Object)active));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.sessionstable.getControl().setLayoutData((Object)gd);
        Group group = new Group(parent, 0);
        group.setText(UIMessages.ExportReportPage1DestinationGroup_label);
        group.setLayoutData((Object)new GridData(768));
        this.createExportOptionsGroup((Composite)group);
        this.opencheckbox = new Button(parent, 32);
        this.opencheckbox.setText(UIMessages.ExportReportOpenReport_label);
        this.setControl((Control)parent);
        ContextHelp.setHelp((Control)parent, "com.mountainminds.eclemma.ui.session_export_context");
        this.restoreWidgetValues();
    }

    private void createExportOptionsGroup(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        new Label(parent, 0).setText(UIMessages.ExportReportPage1Format_label);
        this.formatcombo = new Combo(parent, 8);
        this.formatcombo.add(UIMessages.ExportReportPage1HTMLFormat_value);
        this.formatcombo.add(UIMessages.ExportReportPage1XMLFormat_value);
        this.formatcombo.add(UIMessages.ExportReportPage1TextFormat_value);
        this.formatcombo.add(UIMessages.ExportReportPage1EMMAFormat_value);
        this.formatcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath path = Path.fromOSString((String)SessionExportPage1.this.destinationcombo.getText());
                path = path.removeFileExtension();
                String ext = ISessionExporter.DEFAULT_EXTENSIONS[SessionExportPage1.this.formatcombo.getSelectionIndex()];
                path = path.addFileExtension(ext);
                SessionExportPage1.this.destinationcombo.setText(path.toOSString());
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.formatcombo.setLayoutData((Object)gd);
        new Label(parent, 0).setText(UIMessages.ExportReportPage1Destination_label);
        this.destinationcombo = new Combo(parent, 2048);
        this.destinationcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionExportPage1.this.update();
            }
        });
        gd = new GridData(768);
        gd.widthHint = this.convertHorizontalDLUsToPixels(120);
        this.destinationcombo.setLayoutData((Object)gd);
        Button browsebutton = new Button(parent, 0);
        browsebutton.setText(UIMessages.BrowseAction_label);
        this.setButtonLayoutData(browsebutton);
        browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionExportPage1.this.openBrowseDialog();
            }
        });
        this.update();
    }

    private void openBrowseDialog() {
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setText(UIMessages.ExportReportPage1BrowseDialog_title);
        fd.setFileName(this.destinationcombo.getText());
        String ext = ISessionExporter.DEFAULT_EXTENSIONS[this.formatcombo.getSelectionIndex()];
        fd.setFilterExtensions(new String[]{"*." + ext, "*.*"});
        String file = fd.open();
        if (file != null) {
            this.destinationcombo.setText(file);
        }
    }

    private void update() {
        if (this.getSelectedSession() == null) {
            this.setErrorMessage(UIMessages.ExportReportPage1NoSession_message);
            this.setPageComplete(false);
            return;
        }
        if (this.getDestination().length() == 0) {
            this.setMessage(UIMessages.ExportReportPage1MissingDestination_message);
            this.setPageComplete(false);
            return;
        }
        File f = new File(this.getDestination());
        File p = f.getParentFile();
        if (f.isDirectory() || p != null && !p.isDirectory()) {
            this.setErrorMessage(UIMessages.ExportReportPage1InvalidDestination_message);
            this.setPageComplete(false);
            return;
        }
        String exta = Path.fromOSString((String)this.getDestination()).getFileExtension();
        String exte = ISessionExporter.DEFAULT_EXTENSIONS[this.getReportFormat()];
        if (!exte.equalsIgnoreCase(exta)) {
            this.setMessage(NLS.bind((String)UIMessages.ExportReportPage1WrongExtension_message, (Object)exte), 2);
            this.setPageComplete(true);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        try {
            this.formatcombo.select(settings.getInt(STORE_FORMAT));
        }
        catch (NumberFormatException numberFormatException) {
            this.formatcombo.select(0);
        }
        ComboHistory.restore(settings, STORE_DESTINATIONS, this.destinationcombo);
        this.opencheckbox.setSelection(settings.getBoolean(STORE_OPENREPORT));
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_FORMAT, this.formatcombo.getSelectionIndex());
        ComboHistory.save(settings, STORE_DESTINATIONS, this.destinationcombo);
        settings.put(STORE_OPENREPORT, this.opencheckbox.getSelection());
    }

    public ICoverageSession getSelectedSession() {
        IStructuredSelection sel = (IStructuredSelection)this.sessionstable.getSelection();
        return (ICoverageSession)sel.getFirstElement();
    }

    public int getReportFormat() {
        return this.formatcombo.getSelectionIndex();
    }

    public String getDestination() {
        return this.destinationcombo.getText().trim();
    }

    public boolean getOpenReport() {
        return this.opencheckbox.getSelection();
    }
}

