/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.ui.wizards;

import com.mountainminds.eclemma.core.CoverageTools;
import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.ISessionExporter;
import com.mountainminds.eclemma.internal.ui.EclEmmaUIPlugin;
import com.mountainminds.eclemma.internal.ui.UIMessages;
import com.mountainminds.eclemma.internal.ui.wizards.ExternalFileEditorInput;
import com.mountainminds.eclemma.internal.ui.wizards.SessionExportPage1;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class SessionExportWizard
extends Wizard
implements IExportWizard {
    private static final String SETTINGSID = "SessionExportWizard";
    private IWorkbench workbench;
    private SessionExportPage1 page1;

    public SessionExportWizard() {
        IDialogSettings pluginsettings = EclEmmaUIPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardsettings = pluginsettings.getSection(SETTINGSID);
        if (wizardsettings == null) {
            wizardsettings = pluginsettings.addNewSection(SETTINGSID);
        }
        this.setDialogSettings(wizardsettings);
        this.setWindowTitle(UIMessages.ExportReport_title);
        this.setDefaultPageImageDescriptor(EclEmmaUIPlugin.getImageDescriptor("icons/full/wizban/export_session.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        this.page1 = new SessionExportPage1();
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        this.page1.saveWidgetValues();
        boolean result = this.createReport();
        if (result && this.page1.getOpenReport()) {
            this.openReport();
        }
        return result;
    }

    private boolean createReport() {
        ICoverageSession session = this.page1.getSelectedSession();
        final ISessionExporter exporter = CoverageTools.getExporter((ICoverageSession)session);
        exporter.setFormat(this.page1.getReportFormat());
        exporter.setDestination(this.page1.getDestination());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    exporter.export(monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ite) {
            Throwable ex = ite.getTargetException();
            EclEmmaUIPlugin.log(ex);
            String title = UIMessages.ExportReportErrorDialog_title;
            String msg = UIMessages.ExportReportErrorDialog_message;
            msg = NLS.bind((String)msg, (Object)session.getDescription());
            IStatus status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : EclEmmaUIPlugin.errorStatus(String.valueOf(ex.getMessage()), ex);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)msg, (IStatus)status);
            return false;
        }
        return true;
    }

    private void openReport() {
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        File f = new File(this.page1.getDestination());
        String editorid = this.getEditorId(f);
        if (editorid != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new ExternalFileEditorInput(f), (String)editorid);
            }
            catch (PartInitException e) {
                EclEmmaUIPlugin.log((CoreException)((Object)e));
            }
        }
    }

    private String getEditorId(File file) {
        IEditorRegistry editorRegistry = this.workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        return descriptor == null ? null : descriptor.getId();
    }
}

