/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractImageFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ImageFigure
extends AbstractImageFigure {
    private Image img;
    private Dimension size = new Dimension();
    private int alignment;

    public ImageFigure() {
        this(null, 2);
    }

    public ImageFigure(Image image) {
        this(image, 2);
    }

    public ImageFigure(Image image, int alignment) {
        this.setImage(image);
        this.setAlignment(alignment);
    }

    public Image getImage() {
        return this.img;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.getInsets() == NO_INSETS) {
            return this.size;
        }
        Insets i = this.getInsets();
        return this.size.getExpanded(i.getWidth(), i.getHeight());
    }

    protected void paintFigure(Graphics graphics) {
        int x;
        int y;
        super.paintFigure(graphics);
        if (this.getImage() == null) {
            return;
        }
        Rectangle area = this.getClientArea();
        switch (this.alignment & 5) {
            case 1: {
                y = area.y;
                break;
            }
            case 4: {
                y = area.y + area.height - this.size.height;
                break;
            }
            default: {
                y = (area.height - this.size.height) / 2 + area.y;
            }
        }
        switch (this.alignment & 0x18) {
            case 16: {
                x = area.x + area.width - this.size.width;
                break;
            }
            case 8: {
                x = area.x;
                break;
            }
            default: {
                x = (area.width - this.size.width) / 2 + area.x;
            }
        }
        graphics.drawImage(this.getImage(), x, y);
    }

    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.size = this.img != null ? new Rectangle(image.getBounds()).getSize() : new Dimension();
        this.revalidate();
        this.notifyImageChanged();
        this.repaint();
    }
}

