/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.ActivityDiagram;
import org.eclipse.gef.examples.flow.model.ParallelActivity;
import org.eclipse.gef.examples.flow.model.SequentialActivity;
import org.eclipse.gef.examples.flow.model.Transition;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class FlowWizardPage1
extends WizardNewFileCreationPage {
    private IWorkbench workbench;
    private static int exampleCount = 1;
    static /* synthetic */ Class class$0;

    public FlowWizardPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("sampleFlowPage1", selection);
        this.setTitle("Create Flow Example File");
        this.setDescription("Create a new flow file resource");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.examples.flow.FlowPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"images/flowbanner.gif"));
        this.workbench = aWorkbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("flowExample" + exampleCount + ".flow");
        this.setPageComplete(this.validatePage());
    }

    private ActivityDiagram createWakeupModel() {
        ActivityDiagram diagram = new ActivityDiagram();
        SequentialActivity wakeup = new SequentialActivity();
        Activity backToSleep = new Activity("Go back to sleep");
        Activity turnOff = new Activity("Turn off alarm");
        wakeup.setName("Wake up");
        wakeup.addChild(new Activity("Hit snooze button"));
        wakeup.addChild(backToSleep);
        wakeup.addChild(turnOff);
        wakeup.addChild(new Activity("Get out of bed"));
        diagram.addChild(wakeup);
        SequentialActivity bathroom = new SequentialActivity();
        bathroom.addChild(new Activity("Brush teeth"));
        bathroom.addChild(new Activity("Take shower"));
        bathroom.addChild(new Activity("Comb hair"));
        bathroom.setName("Bathroom activities");
        diagram.addChild(bathroom);
        ParallelActivity relaxation = new ParallelActivity();
        relaxation.addChild(new Activity("Watch cartoons"));
        relaxation.addChild(new Activity("Power Yoga"));
        relaxation.setName("Morning relaxation ritual");
        diagram.addChild(relaxation);
        Activity sleep = new Activity("Sleep.....");
        diagram.addChild(sleep);
        Activity alarm = new Activity("Alarm!!!");
        diagram.addChild(alarm);
        Activity alarm2 = new Activity("Alarm!!!");
        diagram.addChild(alarm2);
        Activity clothes = new Activity("Put on clothes");
        diagram.addChild(clothes);
        Activity spare = new Activity("Is there time to spare?");
        diagram.addChild(spare);
        Activity yes = new Activity("YES");
        diagram.addChild(yes);
        Activity no = new Activity("NO");
        diagram.addChild(no);
        Activity drive = new Activity("Drive to work");
        diagram.addChild(drive);
        new Transition(sleep, alarm);
        new Transition(alarm, wakeup);
        new Transition(backToSleep, alarm2);
        new Transition(alarm2, turnOff);
        new Transition(wakeup, bathroom);
        new Transition(bathroom, clothes);
        new Transition(clothes, spare);
        new Transition(spare, yes);
        new Transition(spare, no);
        new Transition(yes, relaxation);
        new Transition(no, drive);
        new Transition(relaxation, drive);
        return diagram;
    }

    protected InputStream getInitialContents() {
        ActivityDiagram diag = this.createWakeupModel();
        ByteArrayInputStream bais = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(diag);
            oos.flush();
            oos.close();
            baos.close();
            bais = new ByteArrayInputStream(baos.toByteArray());
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bais;
    }

    public boolean finish() {
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        ++exampleCount;
        return true;
    }
}

