/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.rulers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicRuler;
import org.eclipse.gef.examples.logicdesigner.model.commands.CreateGuideCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.DeleteGuideCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.MoveGuideCommand;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;

public class LogicRulerProvider
extends RulerProvider {
    private LogicRuler ruler;
    private PropertyChangeListener rulerListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("children changed")) {
                LogicGuide guide = (LogicGuide)evt.getNewValue();
                if (LogicRulerProvider.this.getGuides().contains(guide)) {
                    guide.addPropertyChangeListener(LogicRulerProvider.this.guideListener);
                } else {
                    guide.removePropertyChangeListener(LogicRulerProvider.this.guideListener);
                }
                int i = 0;
                while (i < LogicRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)LogicRulerProvider.this.listeners.get(i)).notifyGuideReparented((Object)guide);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < LogicRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)LogicRulerProvider.this.listeners.get(i)).notifyUnitsChanged(LogicRulerProvider.this.ruler.getUnit());
                    ++i;
                }
            }
        }
    };
    private PropertyChangeListener guideListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("subparts changed")) {
                int i = 0;
                while (i < LogicRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)LogicRulerProvider.this.listeners.get(i)).notifyPartAttachmentChanged(evt.getNewValue(), evt.getSource());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < LogicRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)LogicRulerProvider.this.listeners.get(i)).notifyGuideMoved(evt.getSource());
                    ++i;
                }
            }
        }
    };

    public LogicRulerProvider(LogicRuler ruler) {
        this.ruler = ruler;
        this.ruler.addPropertyChangeListener(this.rulerListener);
        List guides = this.getGuides();
        int i = 0;
        while (i < guides.size()) {
            ((LogicGuide)guides.get(i)).addPropertyChangeListener(this.guideListener);
            ++i;
        }
    }

    public List getAttachedModelObjects(Object guide) {
        return new ArrayList(((LogicGuide)guide).getParts());
    }

    public Command getCreateGuideCommand(int position) {
        return new CreateGuideCommand(this.ruler, position);
    }

    public Command getDeleteGuideCommand(Object guide) {
        return new DeleteGuideCommand((LogicGuide)guide, this.ruler);
    }

    public Command getMoveGuideCommand(Object guide, int pDelta) {
        return new MoveGuideCommand((LogicGuide)guide, pDelta);
    }

    public int[] getGuidePositions() {
        List guides = this.getGuides();
        int[] result = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            result[i] = ((LogicGuide)guides.get(i)).getPosition();
            ++i;
        }
        return result;
    }

    public Object getRuler() {
        return this.ruler;
    }

    public int getUnit() {
        return this.ruler.getUnit();
    }

    public void setUnit(int newUnit) {
        this.ruler.setUnit(newUnit);
    }

    public int getGuidePosition(Object guide) {
        return ((LogicGuide)guide).getPosition();
    }

    public List getGuides() {
        return this.ruler.getGuides();
    }
}

